<?php
include 'config.php';

// Fetch dynamic content from database
$sections_query = "SELECT * FROM sections WHERE is_active = 1 ORDER BY order_index ASC";
$sections_result = mysqli_query($conn, $sections_query);

$faq_query = "SELECT * FROM faq_items WHERE is_active = 1 ORDER BY order_index ASC";
$faq_result = mysqli_query($conn, $faq_query);

$testimonials_query = "SELECT * FROM testimonials WHERE is_active = 1 ORDER BY created_at DESC LIMIT 3";
$testimonials_result = mysqli_query($conn, $testimonials_query);

$media_query = "SELECT * FROM media_gallery WHERE is_active = 1 ORDER BY order_index ASC";
$media_result = mysqli_query($conn, $media_query);

// Handle form submission
if ($_POST && isset($_POST['fullname'])) {
    // Debug: Log all POST data
    error_log("Form submitted with POST data: " . print_r($_POST, true));
    
    $fullname = mysqli_real_escape_string($conn, $_POST['fullname']);
    $company = mysqli_real_escape_string($conn, $_POST['company']);
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $phone = mysqli_real_escape_string($conn, $_POST['phone']);
    $country = mysqli_real_escape_string($conn, $_POST['country']);
    $city = mysqli_real_escape_string($conn, $_POST['city']);
    $franchise_type = mysqli_real_escape_string($conn, $_POST['franchise_type']);
    $message = mysqli_real_escape_string($conn, $_POST['message']);
    
    // Debug: Check if all required fields are present
    $missing_fields = array();
    if (empty($fullname)) $missing_fields[] = 'fullname';
    if (empty($email)) $missing_fields[] = 'email';
    if (empty($phone)) $missing_fields[] = 'phone';
    if (empty($franchise_type)) $missing_fields[] = 'franchise_type';
    
    if (!empty($missing_fields)) {
        $error_message = "Please fill in all required fields. Missing: " . implode(', ', $missing_fields);
    } else {
        $insert_query = "INSERT INTO franchise_applications (fullname, company, email, phone, country, city, franchise_type, message) 
                        VALUES ('$fullname', '$company', '$email', '$phone', '$country', '$city', '$franchise_type', '$message')";
        
        error_log("Executing query: " . $insert_query);
        
        if (mysqli_query($conn, $insert_query)) {
            $success_message = "Thank you! Your application has been submitted successfully.";
            // Clear form data after successful submission
            $_POST = array();
        } else {
            $error_message = "Error submitting application: " . mysqli_error($conn);
            error_log("MySQL Error: " . mysqli_error($conn));
        }
    }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>TechnoDome Education Franchise — Start Your Own Business</title>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700&display=swap" rel="stylesheet">
  <style>
    :root{
      --bg:#fff7fc;
      --pink:#ff6fb5;
      --violet:#8a5cf6;
      --muted:#b517a;
      --card:#ffffffcc;
      --orange:#ff8c42;
      --green:#4ecdc4;
      --yellow:#ffd93d;
      --blue:#6c5ce7;
      --red:#ff6b6b;
      --gradient1:linear-gradient(135deg, #ff6fb5, #8a5cf6);
      --gradient2:linear-gradient(135deg, #ff8c42, #ff6b6b);
      --gradient3:linear-gradient(135deg, #4ecdc4, #6c5ce7);
      --gradient4:linear-gradient(135deg, #ffd93d, #ff8c42);
    }
    *{box-sizing:border-box}html,body{height:100%;margin:0;font-family:Inter,system-ui,Segoe UI,Roboto,Arial;color:#2b1633;background:linear-gradient(180deg,var(--bg),#fff)}
    a{color:inherit;text-decoration:none}

    /* Animated background */
    body::before {
      content: '';
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: 
        radial-gradient(circle at 20% 80%, rgba(255, 111, 181, 0.1) 0%, transparent 50%),
        radial-gradient(circle at 80% 20%, rgba(138, 92, 246, 0.1) 0%, transparent 50%),
        radial-gradient(circle at 40% 40%, rgba(255, 140, 66, 0.05) 0%, transparent 50%);
      z-index: -1;
      animation: backgroundShift 20s ease-in-out infinite;
    }

    @keyframes backgroundShift {
      0%, 100% { transform: translateX(0) translateY(0); }
      25% { transform: translateX(-10px) translateY(-5px); }
      50% { transform: translateX(5px) translateY(-10px); }
      75% { transform: translateX(-5px) translateY(5px); }
    }

    header{
      position:sticky;top:0;background:rgba(255,255,255,0.8);backdrop-filter:blur(12px);
      box-shadow:0 8px 32px rgba(138,92,246,0.1);padding:14px 22px;z-index:40;
      border-bottom: 1px solid rgba(255,111,181,0.1);
      animation: headerSlide 0.6s ease-out;
    }

    @keyframes headerSlide {
      from { transform: translateY(-100%); opacity: 0; }
      to { transform: translateY(0); opacity: 1; }
    }

    .wrap{max-width:1150px;margin:0 auto;padding:0 18px}
    .nav{display:flex;align-items:center;justify-content:space-between}
    .brand{display:flex;align-items:center;gap:12px;animation: brandPulse 2s ease-in-out infinite}
    
    @keyframes brandPulse {
      0%, 100% { transform: scale(1); }
      50% { transform: scale(1.02); }
    }

    .logo{
      width:50px;height:50px;border-radius:12px;background:var(--gradient1);
      color:white;display:grid;place-items:center;font-weight:800;
      animation: logoRotate 3s ease-in-out infinite;
      box-shadow: 0 4px 20px rgba(255,111,181,0.3);
    }

    @keyframes logoRotate {
      0%, 100% { transform: rotate(0deg) scale(1); }
      25% { transform: rotate(5deg) scale(1.05); }
      50% { transform: rotate(0deg) scale(1.1); }
      75% { transform: rotate(-5deg) scale(1.05); }
    }

    nav ul{display:flex;gap:12px;align-items:center;margin:0;padding:0;list-style:none}
    nav a{
      padding:8px 16px;border-radius:20px;font-weight:600;
      transition: all 0.3s ease;position:relative;overflow:hidden;
      background: linear-gradient(45deg, transparent, transparent);
    }
    
    nav a::before {
      content: '';
      position: absolute;
      top: 0;
      left: -100%;
      width: 100%;
      height: 100%;
      background: var(--gradient1);
      transition: left 0.3s ease;
      z-index: -1;
    }
    
    nav a:hover::before { left: 0; }
    nav a:hover { color: white; transform: translateY(-2px); }

    .hero{
      display:grid;grid-template-columns:1fr 380px;gap:28px;align-items:start;padding:46px 0;
      animation: heroFadeIn 1s ease-out;
    }

    @keyframes heroFadeIn {
      from { opacity: 0; transform: translateY(30px); }
      to { opacity: 1; transform: translateY(0); }
    }

    .kicker{
      display:inline-block;padding:8px 16px;border-radius:25px;
      background:var(--gradient2);color:white;font-weight:700;
      animation: kickerBounce 2s ease-in-out infinite;
      box-shadow: 0 4px 15px rgba(255,140,66,0.3);
    }

    @keyframes kickerBounce {
      0%, 100% { transform: translateY(0); }
      50% { transform: translateY(-3px); }
    }

    h1{
      font-size:34px;margin:14px 0 10px;line-height:1.06;
      background: var(--gradient1);-webkit-background-clip: text;
      -webkit-text-fill-color: transparent;background-clip: text;
      animation: titleGlow 3s ease-in-out infinite;
    }

    @keyframes titleGlow {
      0%, 100% { filter: brightness(1); }
      50% { filter: brightness(1.1); }
    }

    .lead{color:var(--muted);margin-bottom:20px;animation: leadSlide 1.2s ease-out 0.3s both}
    
    @keyframes leadSlide {
      from { opacity: 0; transform: translateX(-20px); }
      to { opacity: 1; transform: translateX(0); }
    }

    .cta-row{display:flex;gap:12px;align-items:center}
    .btn{
      background:var(--gradient1);color:white;padding:12px 24px;border-radius:25px;
      border:0;font-weight:700;cursor:pointer;transition:all 0.3s ease;
      position:relative;overflow:hidden;box-shadow: 0 4px 20px rgba(255,111,181,0.3);
    }
    
    .btn::before {
      content: '';
      position: absolute;
      top: 0;
      left: -100%;
      width: 100%;
      height: 100%;
      background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
      transition: left 0.5s ease;
    }
    
    .btn:hover::before { left: 100%; }
    .btn:hover{transform:translateY(-3px) scale(1.05);box-shadow: 0 8px 30px rgba(255,111,181,0.4);}

    /* Right form */
    .enquiry{
      background:linear-gradient(180deg,rgba(255,255,255,0.95),rgba(255,255,255,0.85));
      padding:25px;border-radius:20px;box-shadow:0 15px 40px rgba(138,92,246,0.15);
      backdrop-filter:blur(10px);border:1px solid rgba(255,111,181,0.1);
      animation: formSlide 0.8s ease-out 0.4s both;
    }

    @keyframes formSlide {
      from { opacity: 0; transform: translateX(50px); }
      to { opacity: 1; transform: translateX(0); }
    }

    .enquiry h3{
      margin:0 0 15px;background:var(--gradient1);-webkit-background-clip: text;
      -webkit-text-fill-color: transparent;background-clip: text;
      animation: titlePulse 2s ease-in-out infinite;
    }

    @keyframes titlePulse {
      0%, 100% { transform: scale(1); }
      50% { transform: scale(1.02); }
    }

    .field{margin-bottom:15px;position:relative}
    .field label{
      display:block;font-size:13px;margin-bottom:8px;color:var(--muted);
      font-weight:600;transition:color 0.3s ease;
    }
    
    .field input,.field select, .field textarea{
      width:100%;padding:12px 16px;border-radius:12px;
      border:2px solid rgba(255,111,181,0.2);background:#fff;
      transition:all 0.3s ease;font-size:14px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    }
    
    .field input:focus,.field select:focus, .field textarea:focus{
      outline:none;border-color:var(--pink);transform:translateY(-2px);
      box-shadow: 0 8px 25px rgba(255,111,181,0.2);
    }

    .field input:hover, .field select:hover, .field textarea:hover {
      border-color:var(--violet);transform:translateY(-1px);
    }

    /* sections */
    section{
      padding:40px 0;border-top:1px solid rgba(138,92,246,0.04);
      animation: sectionFade 0.6s ease-out;
    }

    @keyframes sectionFade {
      from { opacity: 0; transform: translateY(20px); }
      to { opacity: 1; transform: translateY(0); }
    }

    .cards{
      display:grid;grid-template-columns:repeat(3,1fr);gap:20px;margin-top:20px;
      animation: cardsFloat 0.8s ease-out;
    }

    @keyframes cardsFloat {
      from { opacity: 0; transform: translateY(30px); }
      to { opacity: 1; transform: translateY(0); }
    }

    .card{
      background:var(--card);padding:20px;border-radius:16px;
      backdrop-filter:blur(10px);box-shadow:0 10px 40px rgba(138,92,246,0.1);
      transition:all 0.4s ease;position:relative;overflow:hidden;
      border:1px solid rgba(255,111,181,0.1);
    }

    .card::before {
      content: '';
      position: absolute;
      top: 0;
      left: -100%;
      width: 100%;
      height: 100%;
      background: linear-gradient(90deg, transparent, rgba(255,111,181,0.1), transparent);
      transition: left 0.6s ease;
    }

    .card:hover::before { left: 100%; }
    .card:hover{
      transform:translateY(-8px) scale(1.02);
      box-shadow: 0 20px 60px rgba(138,92,246,0.2);
      border-color:var(--pink);
    }

    .card:nth-child(1) { animation-delay: 0.1s; }
    .card:nth-child(2) { animation-delay: 0.2s; }
    .card:nth-child(3) { animation-delay: 0.3s; }

    .card h4{
      margin:0 0 10px;background:var(--gradient2);-webkit-background-clip: text;
      -webkit-text-fill-color: transparent;background-clip: text;
      font-size:18px;font-weight:700;
    }
    .card p{margin:0;color:var(--muted);font-size:14px;line-height:1.5}

    .process{
      display:grid;grid-template-columns:repeat(4,1fr);gap:20px;margin-top:20px;
      animation: processSlide 1s ease-out;
    }

    @keyframes processSlide {
      from { opacity: 0; transform: translateY(40px); }
      to { opacity: 1; transform: translateY(0); }
    }

    .step{
      background:linear-gradient(135deg,#fff,#f8f9ff);padding:20px;border-radius:16px;
      text-align:center;box-shadow:0 10px 30px rgba(138,92,246,0.1);
      transition:all 0.4s ease;position:relative;overflow:hidden;
      border:2px solid rgba(255,111,181,0.1);
    }

    .step::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: var(--gradient3);
      opacity: 0;
      transition: opacity 0.3s ease;
      z-index: -1;
    }

    .step:hover::before { opacity: 0.1; }
    .step:hover{
      transform:translateY(-8px) scale(1.05);
      box-shadow: 0 20px 50px rgba(138,92,246,0.2);
      border-color:var(--pink);
    }

    .step:nth-child(1) { animation-delay: 0.1s; }
    .step:nth-child(2) { animation-delay: 0.2s; }
    .step:nth-child(3) { animation-delay: 0.3s; }
    .step:nth-child(4) { animation-delay: 0.4s; }

    .step h5{
      margin:12px 0 8px;background:var(--gradient1);-webkit-background-clip: text;
      -webkit-text-fill-color: transparent;background-clip: text;
      font-size:16px;font-weight:700;
    }

    .step div {
      width: 40px; height: 40px; border-radius: 50%;
      background: var(--gradient2); color: white;
      display: flex; align-items: center; justify-content: center;
      font-weight: 800; font-size: 18px; margin: 0 auto 10px;
      animation: stepPulse 2s ease-in-out infinite;
    }

    @keyframes stepPulse {
      0%, 100% { transform: scale(1); }
      50% { transform: scale(1.1); }
    }

    .two-col{display:grid;grid-template-columns:1fr 1fr;gap:20px;animation: twoColSlide 0.8s ease-out}

    @keyframes twoColSlide {
      from { opacity: 0; transform: translateX(-20px); }
      to { opacity: 1; transform: translateX(0); }
    }

    .testimonials{
      display:grid;grid-template-columns:repeat(3,1fr);gap:20px;margin-top:20px;
      animation: testimonialsFloat 1s ease-out;
    }

    @keyframes testimonialsFloat {
      from { opacity: 0; transform: translateY(30px); }
      to { opacity: 1; transform: translateY(0); }
    }

    .testimonial{
      background:linear-gradient(135deg,#fff,#fff0fb);padding:20px;border-radius:16px;
      border:2px solid rgba(255,111,181,0.1);transition:all 0.4s ease;
      position:relative;overflow:hidden;box-shadow: 0 8px 25px rgba(138,92,246,0.1);
    }

    .testimonial::before {
      content: '';
      position: absolute;
      top: 0;
      left: -100%;
      width: 100%;
      height: 100%;
      background: linear-gradient(90deg, transparent, rgba(255,111,181,0.1), transparent);
      transition: left 0.6s ease;
    }

    .testimonial:hover::before { left: 100%; }
    .testimonial:hover{
      transform:translateY(-6px) scale(1.02);
      box-shadow: 0 15px 40px rgba(138,92,246,0.2);
      border-color:var(--pink);
    }

    .testimonial:nth-child(1) { animation-delay: 0.1s; }
    .testimonial:nth-child(2) { animation-delay: 0.2s; }
    .testimonial:nth-child(3) { animation-delay: 0.3s; }

    .faq-item{
      margin-bottom:15px;border:2px solid rgba(255,111,181,0.1);
      border-radius:12px;overflow:hidden;transition:all 0.3s ease;
      animation: faqSlide 0.6s ease-out;
    }

    @keyframes faqSlide {
      from { opacity: 0; transform: translateX(-20px); }
      to { opacity: 1; transform: translateX(0); }
    }

    .faq-item:hover { border-color: var(--pink); }

    .faq-question{
      background:linear-gradient(135deg,#fff,#f8f9ff);padding:16px;cursor:pointer;
      font-weight:600;transition:all 0.3s ease;position:relative;
      border-bottom: 1px solid rgba(255,111,181,0.1);
    }

    .faq-question:hover{
      background:var(--gradient1);color:white;transform:translateY(-2px);
      box-shadow: 0 5px 15px rgba(255,111,181,0.3);
    }

    .faq-answer{
      background:linear-gradient(135deg,#f8f9ff,#fff);padding:16px;
      display:none;color:var(--muted);line-height:1.6;
      animation: faqAnswerSlide 0.3s ease-out;
    }

    @keyframes faqAnswerSlide {
      from { opacity: 0; transform: translateY(-10px); }
      to { opacity: 1; transform: translateY(0); }
    }

    .alert{
      padding:15px;border-radius:12px;margin-bottom:20px;font-weight:600;
      animation: alertSlide 0.5s ease-out;
    }

    @keyframes alertSlide {
      from { opacity: 0; transform: translateY(-20px); }
      to { opacity: 1; transform: translateY(0); }
    }

    .alert-success{
      background:linear-gradient(135deg,#d4edda,#c3e6cb);color:#155724;
      border:2px solid #c3e6cb;box-shadow: 0 4px 15px rgba(21,87,36,0.1);
    }

    .alert-error{
      background:linear-gradient(135deg,#f8d7da,#f5c6cb);color:#721c24;
      border:2px solid #f5c6cb;box-shadow: 0 4px 15px rgba(114,28,36,0.1);
    }

    footer{
      padding:40px 0;color:var(--muted);background:linear-gradient(135deg,#f8f9ff,#fff);
      border-top: 1px solid rgba(255,111,181,0.1);
      animation: footerFade 1s ease-out;
    }

    @keyframes footerFade {
      from { opacity: 0; transform: translateY(20px); }
      to { opacity: 1; transform: translateY(0); }
    }

    /* Floating particles animation */
    .floating-particles {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      pointer-events: none;
      z-index: -1;
    }

    .particle {
      position: absolute;
      width: 4px;
      height: 4px;
      background: var(--gradient1);
      border-radius: 50%;
      animation: float 6s ease-in-out infinite;
    }

    @keyframes float {
      0%, 100% { transform: translateY(0) rotate(0deg); opacity: 0.3; }
      50% { transform: translateY(-20px) rotate(180deg); opacity: 0.8; }
    }

    /* Media Gallery Animations */
    .media-item {
      animation: mediaSlide 0.8s ease-out;
    }

    @keyframes mediaSlide {
      from { opacity: 0; transform: translateY(30px) scale(0.95); }
      to { opacity: 1; transform: translateY(0) scale(1); }
    }

    .media-item:hover {
      transform: translateY(-8px) scale(1.02);
      box-shadow: 0 20px 60px rgba(138,92,246,0.2);
    }

    .media-item:nth-child(1) { animation-delay: 0.1s; }
    .media-item:nth-child(2) { animation-delay: 0.2s; }
    .media-item:nth-child(3) { animation-delay: 0.3s; }
    .media-item:nth-child(4) { animation-delay: 0.4s; }
    .media-item:nth-child(5) { animation-delay: 0.5s; }
    .media-item:nth-child(6) { animation-delay: 0.6s; }

    @media(max-width:980px){
      .hero{grid-template-columns:1fr 320px}
      .cards{grid-template-columns:repeat(2,1fr)}
      .process{grid-template-columns:repeat(2,1fr)}
      .testimonials{grid-template-columns:1fr}
      .media-grid{grid-template-columns:repeat(2,1fr)}
    }
    @media(max-width:720px){
      .hero{grid-template-columns:1fr}
      .enquiry{order:2}
      .cards{grid-template-columns:1fr}
      .two-col{grid-template-columns:1fr}
      .media-grid{grid-template-columns:1fr}
    }
  </style>
</head>
<body>
  <main class="wrap">
    <section class="hero">
      <div>
        <span class="kicker">Franchise Enquiry</span>
        <h1>Launch Your Profitable Franchise Today with TechnoDome!</h1>
        <p class="lead">Join the TechnoDome family and grow a high-return, low-cost education franchise focused on competitive exam coaching across India. Fast ROI – Start earning within months.</p>
        <div class="cards">
          <div class="card">
            <h4>Fast ROI</h4>
            <p>Start earning within months with our proven business model and support system.</p>
          </div>
          <div class="card">
            <h4>Local + Global Reach</h4>
            <p>Double your market reach with both local students and online coaching opportunities.</p>
          </div>
          <div class="card">
            <h4>15+ Years Expertise</h4>
            <p>Backed by a trusted brand with comprehensive training and ongoing support.</p>
          </div>
        </div>
      </div>

      <aside class="enquiry">
        <h3>Franchise Enquiry</h3>
        <?php if (isset($success_message)): ?>
          <div class="alert alert-success"><?php echo $success_message; ?></div>
        <?php endif; ?>
        <?php if (isset($error_message)): ?>
          <div class="alert alert-error"><?php echo $error_message; ?></div>
        <?php endif; ?>
        <form method="POST">
          <div class="field">
            <label>Full Name *</label>
            <input name="fullname" placeholder="Your full name" required />
          </div>
          <div class="field">
            <label>Company / Business Name</label>
            <input name="company" placeholder="If any" />
          </div>
          <div class="field">
            <label>Email *</label>
            <input name="email" type="email" placeholder="you@example.com" required />
          </div>
          <div class="field">
            <label>Phone *</label>
            <input name="phone" type="tel" placeholder="+91 98765 43210" required />
          </div>
          <div class="field">
            <label>Country</label>
            <select name="country">
              <option value="India">India</option>
              <option value="United States">United States</option>
              <option value="United Kingdom">United Kingdom</option>
              <option value="United Arab Emirates">United Arab Emirates</option>
              <option value="Other">Other</option>
            </select>
          </div>
          <div class="field">
            <label>City / Location</label>
            <input name="city" placeholder="City, State" />
          </div>
          <div class="field">
            <label>Franchise Type *</label>
            <select name="franchise_type" required>
              <option value="">Select Franchise Type</option>
              <option value="Education Franchise">Education Franchise</option>
              <option value="Software Franchise">Software Franchise</option>
            </select>
          </div>
          <div class="field">
            <label>Message / Business Plan (optional)</label>
            <textarea name="message" rows="3" placeholder="Tell us more about your background and why you'd like to join"></textarea>
          </div>
          <div style="display:flex;gap:8px;align-items:center;margin-top:10px">
            <input type="checkbox" id="agree" required />
            <label for="agree" style="font-size:12px;color:var(--muted)">I agree to be contacted about franchise opportunities.</label>
          </div>
          <div style="display:flex;gap:8px;align-items:center;margin-top:10px">
            <button class="btn" type="submit">Send Application</button>
            <button type="button" onclick="resetForm()" style="background:transparent;color:var(--violet);border:1px solid var(--violet);padding:11px 16px;border-radius:10px;font-weight:700;cursor:pointer">Reset</button>
          </div>
          <div style="margin-top:8px">
            <a href="#contact" style="font-weight:700;color:var(--violet);font-size:13px">Talk to us: +91 6289200867</a>
          </div>
        </form>
      </aside>
    </section>

    <?php while ($section = mysqli_fetch_assoc($sections_result)): ?>
    <section id="<?php echo strtolower(str_replace(' ', '-', $section['section_name'])); ?>">
      <h2><?php echo htmlspecialchars($section['title']); ?></h2>
      <p><?php echo nl2br(htmlspecialchars($section['content'])); ?></p>
    </section>
    <?php endwhile; ?>

    <section id="courses">
      <h2>Courses We Offer</h2>
      <div class="cards">
        <div class="card"><h4>Teaching (TET, CTET)</h4><p>Duration: 4 Months</p></div>
        <div class="card"><h4>Banking (IBPS, SBI)</h4><p>Duration: 4 Months</p></div>
        <div class="card"><h4>SSC (CGL, CHSL)</h4><p>Duration: 5 Months</p></div>
      </div>
    </section>

    <section id="process">
      <h2>Education Franchise Step by Step Process</h2>
      <div class="process">
        <div class="step"><div style="font-weight:800">1</div><h5>Express Interest</h5><p style="font-size:13px;color:var(--muted)">Now apply for your franchise anytime online and from anywhere with the help of the Technodome website.</p></div>
        <div class="step"><div style="font-weight:800">2</div><h5>Proposal</h5><p style="font-size:13px;color:var(--muted)">Franchise evaluation & proposal.</p></div>
        <div class="step"><div style="font-weight:800">3</div><h5>Meeting</h5><p style="font-size:13px;color:var(--muted)">Discuss details and support.</p></div>
        <div class="step"><div style="font-weight:800">4</div><h5>Approval</h5><p style="font-size:13px;color:var(--muted)">Finalize agreement & start.</p></div>
      </div>
    </section>

    <section id="requirements">
      <h2>Investment & Franchisee Requirements</h2>
      <div class="two-col" style="margin-top:12px">
        <div class="card"><h4>Investment Range</h4><p>₹2,00,000 - ₹5,00,000 (Low cost franchise with high profit)</p></div>
        <div class="card"><h4>Area Required</h4><p>1000 - 1500 sq. ft. minimum</p></div>
      </div>
      <div style="margin-top:20px;background:var(--card);padding:20px;border-radius:12px">
        <h3 style="margin-top:0">Franchisee Requirements</h3>
        <ul style="color:var(--muted);margin:12px 0;padding-left:20px">
          <li>Dynamic and positive view towards life</li>
          <li>Managerial skills and administrative experience</li>
          <li>Local market knowledge and involvement</li>
          <li>Flexibility to work different shifts</li>
          <li>Strong ethical sense and patience</li>
          <li>Basic computer & internet setup</li>
        </ul>
      </div>
    </section>

    <section id="faq">
      <h2>Frequently Asked Questions</h2>
      <?php while ($faq = mysqli_fetch_assoc($faq_result)): ?>
      <div class="faq-item">
        <div class="faq-question" onclick="toggleFaq(this)">
          <?php echo htmlspecialchars($faq['question']); ?>
        </div>
        <div class="faq-answer">
          <?php echo nl2br(htmlspecialchars($faq['answer'])); ?>
        </div>
      </div>
      <?php endwhile; ?>
    </section>

    <section id="testimonials">
      <h2>Franchise Partner Testimonials</h2>
      <div class="testimonials">
        <?php while ($testimonial = mysqli_fetch_assoc($testimonials_result)): ?>
        <div class="testimonial">
          <strong><?php echo htmlspecialchars($testimonial['name']); ?></strong>
          <div style="font-size:13px;color:var(--muted)"><?php echo htmlspecialchars($testimonial['location']); ?></div>
          <p style="margin-top:8px;color:var(--muted)">"<?php echo htmlspecialchars($testimonial['testimonial']); ?>"</p>
        </div>
        <?php endwhile; ?>
      </div>
    </section>

    <section id="media-gallery">
      <h2>Success Stories & Media</h2>
      <div class="media-grid" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(350px, 1fr)); gap: 25px; margin-top: 20px;">
        <?php while ($media = mysqli_fetch_assoc($media_result)): ?>
        <div class="media-item" style="background: var(--card); border-radius: 16px; overflow: hidden; box-shadow: 0 10px 40px rgba(138,92,246,0.1); transition: all 0.4s ease; position: relative;">
          <?php if ($media['media_type'] == 'video'): ?>
            <div style="position: relative; padding-bottom: 56.25%; background: linear-gradient(135deg, #f8f9ff, #fff);">
              <?php if ($media['youtube_id']): ?>
                <iframe width="100%" height="100%" src="https://www.youtube.com/embed/<?php echo htmlspecialchars($media['youtube_id']); ?>?rel=0&modestbranding=1" 
                        frameborder="0" allowfullscreen style="position: absolute; top: 0; left: 0; border-radius: 16px 16px 0 0;"></iframe>
              <?php else: ?>
                <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); color: var(--muted); text-align: center;">
                  <div style="font-size: 48px; margin-bottom: 10px;">🎥</div>
                  <div style="font-size: 14px;">Video Content</div>
                </div>
              <?php endif; ?>
            </div>
          <?php else: ?>
            <div style="position: relative; height: 200px; overflow: hidden;">
              <img src="<?php echo htmlspecialchars($media['file_url']); ?>" 
                   alt="<?php echo htmlspecialchars($media['title']); ?>" 
                   style="width: 100%; height: 100%; object-fit: cover; transition: transform 0.4s ease;"
                   onmouseover="this.style.transform='scale(1.05)'" 
                   onmouseout="this.style.transform='scale(1)'">
              <div style="position: absolute; top: 10px; right: 10px; background: rgba(255,111,181,0.9); color: white; padding: 4px 8px; border-radius: 12px; font-size: 12px; font-weight: 600;">
                📸 Image
              </div>
            </div>
          <?php endif; ?>
          
          <div style="padding: 20px;">
            <h4 style="margin: 0 0 10px; background: var(--gradient1); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text; font-size: 18px; font-weight: 700;">
              <?php echo htmlspecialchars($media['title']); ?>
            </h4>
            <p style="margin: 0; color: var(--muted); font-size: 14px; line-height: 1.5;">
              <?php echo htmlspecialchars($media['description']); ?>
            </p>
          </div>
        </div>
        <?php endwhile; ?>
      </div>
    </section>

    <section id="contact">
      <h2 style="display:flex;align-items:center;justify-content:space-between">Ready to Start Your Franchise Journey? <a class="btn" href="#enquiry">Apply Now</a></h2>
      <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(250px,1fr));gap:20px;margin-top:20px">
        <div class="card">
          <h4>Contact Information</h4>
          <p style="color:var(--muted)">Phone: <strong>+91 6289200867</strong><br>Email: <strong>franchise@technodome.com</strong></p>
        </div>
        <div class="card">
          <h4>Global Presence</h4>
          <p style="color:var(--muted)">We serve across India with plans for international expansion. Join our growing network!</p>
        </div>
      </div>
    </section>

    <footer>
      <div style="display:flex;justify-content:space-between;align-items:center;flex-wrap:wrap">
        <div style="color:var(--muted)">© TechnoDome Institute — Education Franchise</div>
        <div style="color:var(--muted)">Designed in Pink & Blue Theme</div>
      </div>
    </footer>
  </main>

  <!-- Floating Particles -->
  <div class="floating-particles" id="particles"></div>

  <script>
    // Create floating particles
    function createParticles() {
      const particlesContainer = document.getElementById('particles');
      const particleCount = 20;
      
      for (let i = 0; i < particleCount; i++) {
        const particle = document.createElement('div');
        particle.className = 'particle';
        particle.style.left = Math.random() * 100 + '%';
        particle.style.top = Math.random() * 100 + '%';
        particle.style.animationDelay = Math.random() * 6 + 's';
        particle.style.animationDuration = (Math.random() * 4 + 4) + 's';
        particlesContainer.appendChild(particle);
      }
    }

    // Initialize particles on load
    document.addEventListener('DOMContentLoaded', function() {
      createParticles();
    });
    function resetForm() {
      document.querySelector('form').reset();
    }

    function toggleFaq(element) {
      const answer = element.nextElementSibling;
      const isVisible = answer.style.display === 'block';
      
      // Close all other FAQ answers
      document.querySelectorAll('.faq-answer').forEach(ans => {
        ans.style.display = 'none';
      });
      
      // Toggle current answer
      answer.style.display = isVisible ? 'none' : 'block';
      
      // Add rotation animation to question
      element.style.transform = isVisible ? 'rotate(0deg)' : 'rotate(2deg)';
      setTimeout(() => {
        element.style.transform = 'rotate(0deg)';
      }, 200);
    }

    // Enhanced smooth scrolling with offset
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
      anchor.addEventListener('click', function (e) {
        e.preventDefault();
        const target = document.querySelector(this.getAttribute('href'));
        if (target) {
          const headerHeight = document.querySelector('header').offsetHeight;
          const targetPosition = target.offsetTop - headerHeight - 20;
          
          window.scrollTo({
            top: targetPosition,
            behavior: 'smooth'
          });
        }
      });
    });

    // Enhanced card interactions with ripple effect
    document.querySelectorAll('.card').forEach(card => {
      card.addEventListener('mouseenter', function() {
        this.style.transform = 'translateY(-8px) scale(1.02)';
        this.style.transition = 'all 0.4s cubic-bezier(0.4, 0, 0.2, 1)';
        
        // Add glow effect
        this.style.boxShadow = '0 20px 60px rgba(138,92,246,0.2)';
      });
      
      card.addEventListener('mouseleave', function() {
        this.style.transform = 'translateY(0) scale(1)';
        this.style.boxShadow = '0 10px 40px rgba(138,92,246,0.1)';
      });

      // Add click ripple effect
      card.addEventListener('click', function(e) {
        const ripple = document.createElement('span');
        const rect = this.getBoundingClientRect();
        const size = Math.max(rect.width, rect.height);
        const x = e.clientX - rect.left - size / 2;
        const y = e.clientY - rect.top - size / 2;
        
        ripple.style.cssText = `
          position: absolute;
          width: ${size}px;
          height: ${size}px;
          left: ${x}px;
          top: ${y}px;
          background: radial-gradient(circle, rgba(255,111,181,0.3) 0%, transparent 70%);
          border-radius: 50%;
          transform: scale(0);
          animation: ripple 0.6s ease-out;
          pointer-events: none;
        `;
        
        this.appendChild(ripple);
        setTimeout(() => ripple.remove(), 600);
      });
    });

    // Add ripple animation CSS
    const style = document.createElement('style');
    style.textContent = `
      @keyframes ripple {
        to {
          transform: scale(2);
          opacity: 0;
        }
      }
    `;
    document.head.appendChild(style);

    // Form validation with visual feedback
    document.querySelector('form').addEventListener('submit', function(e) {
      // Don't prevent default - let the form submit normally to PHP
      const submitBtn = this.querySelector('button[type="submit"]');
      const originalText = submitBtn.textContent;
      
      // Add loading animation
      submitBtn.innerHTML = '<span style="display:inline-block;animation:spin 1s linear infinite;">⟳</span> Sending...';
      submitBtn.disabled = true;
      
      // Add spin animation
      const spinStyle = document.createElement('style');
      spinStyle.textContent = `
        @keyframes spin {
          from { transform: rotate(0deg); }
          to { transform: rotate(360deg); }
        }
      `;
      document.head.appendChild(spinStyle);
      
      // The form will submit to the server and reload the page with success/error message
    });

    // Intersection Observer for scroll animations
    const observerOptions = {
      threshold: 0.1,
      rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver((entries) => {
      entries.forEach(entry => {
        if (entry.isIntersecting) {
          entry.target.style.animationPlayState = 'running';
        }
      });
    }, observerOptions);

    // Observe all animated elements
    document.querySelectorAll('.card, .step, .testimonial, .faq-item').forEach(el => {
      el.style.animationPlayState = 'paused';
      observer.observe(el);
    });

    // Add typing effect to main heading
    function typeWriter(element, text, speed = 100) {
      let i = 0;
      element.innerHTML = '';
      
      function type() {
        if (i < text.length) {
          element.innerHTML += text.charAt(i);
          i++;
          setTimeout(type, speed);
        }
      }
      type();
    }

    // Apply typing effect to h1 on load
    document.addEventListener('DOMContentLoaded', function() {
      const h1 = document.querySelector('h1');
      if (h1) {
        const originalText = h1.textContent;
        typeWriter(h1, originalText, 50);
      }
    });

    // Add parallax effect to background
    window.addEventListener('scroll', function() {
      const scrolled = window.pageYOffset;
      const parallax = document.querySelector('body::before');
      if (parallax) {
        parallax.style.transform = `translateY(${scrolled * 0.5}px)`;
      }
    });

    // Add color-changing effect to logo
    setInterval(() => {
      const logo = document.querySelector('.logo');
      if (logo) {
        const gradients = [
          'linear-gradient(135deg, #ff6fb5, #8a5cf6)',
          'linear-gradient(135deg, #ff8c42, #ff6b6b)',
          'linear-gradient(135deg, #4ecdc4, #6c5ce7)',
          'linear-gradient(135deg, #ffd93d, #ff8c42)'
        ];
        const randomGradient = gradients[Math.floor(Math.random() * gradients.length)];
        logo.style.background = randomGradient;
      }
    }, 3000);
  </script>
</body>
</html>
