-- Database setup for dynamic franchise page
CREATE DATABASE IF NOT EXISTS franchise_db;
USE franchise_db;

-- Table for dynamic content sections
CREATE TABLE IF NOT EXISTS sections (
    id INT AUTO_INCREMENT PRIMARY KEY,
    section_name VARCHAR(100) NOT NULL,
    section_type ENUM('hero', 'benefits', 'process', 'investment', 'requirements', 'faq', 'testimonials', 'contact', 'gallery', 'videos') NOT NULL,
    title VARCHAR(255),
    content TEXT,
    image_url VARCHAR(500),
    video_url VARCHAR(500),
    video_type ENUM('youtube', 'vimeo', 'upload') DEFAULT 'youtube',
    order_index INT DEFAULT 0,
    is_active BOOLEAN DEFAULT TRUE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Table for media gallery
CREATE TABLE IF NOT EXISTS media_gallery (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255),
    description TEXT,
    media_type ENUM('image', 'video') NOT NULL,
    file_url VARCHAR(500),
    youtube_id VARCHAR(100),
    thumbnail_url VARCHAR(500),
    order_index INT DEFAULT 0,
    is_active BOOLEAN DEFAULT TRUE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Table for FAQ items
CREATE TABLE IF NOT EXISTS faq_items (
    id INT AUTO_INCREMENT PRIMARY KEY,
    question TEXT NOT NULL,
    answer TEXT NOT NULL,
    order_index INT DEFAULT 0,
    is_active BOOLEAN DEFAULT TRUE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Table for testimonials
CREATE TABLE IF NOT EXISTS testimonials (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    location VARCHAR(100),
    testimonial TEXT NOT NULL,
    rating INT DEFAULT 5,
    is_active BOOLEAN DEFAULT TRUE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Table for franchise applications
CREATE TABLE IF NOT EXISTS franchise_applications (
    id INT AUTO_INCREMENT PRIMARY KEY,
    fullname VARCHAR(100) NOT NULL,
    company VARCHAR(100),
    email VARCHAR(100) NOT NULL,
    phone VARCHAR(20) NOT NULL,
    country VARCHAR(50),
    city VARCHAR(100),
    franchise_type ENUM('Education Franchise', 'Software Franchise') NOT NULL,
    message TEXT,
    status ENUM('pending', 'contacted', 'approved', 'rejected') DEFAULT 'pending',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Insert default content
INSERT INTO sections (section_name, section_type, title, content, order_index) VALUES
('Hero Section', 'hero', 'Start Your Own Education Franchise with TechnoDome', 'Find the Best Education Franchise in India to boost your business in this sector. Join with the TechnoDome family for experiencing great success and a high return on investment with our Institute Franchise.', 1),
('Why Choose Us', 'benefits', 'Why Choose TechnoDome – The Best Education Franchise?', 'TechnoDome Institute as the best education franchise in India can offer you multiple perks through its professionally designed academic services, which aims to cultivate the best of applied knowledge in students.', 2),
('Franchise Process', 'process', 'Education Franchise Step by Step Process', 'Our proven 4-step process to get you started with your franchise', 3),
('Investment Details', 'investment', 'Investment & Fees', 'Transparent fee structure with detailed breakdown of costs and returns', 4),
('Requirements', 'requirements', 'Franchisee Requirements', 'What you need to become our franchise partner', 5),
('Contact Info', 'contact', 'Get In Touch', 'Ready to start your franchise journey? Contact us today!', 6);

INSERT INTO faq_items (question, answer, order_index) VALUES
('What is the Investment Requirement for the Franchise?', 'On a basic level, you might need to invest 2 lac rupees. It is Low cost Franchise with high profit in India. But, in case you want progressive plans in mind such as extending the services of the organization or being more accessible to an increased number of students; then you might consider investing anywhere from 3 lac rupees to a maximum of 5 lac rupees.', 1),
('What qualities does TechnoDome Institute look for in a person?', 'TechnoDome Institute as the most profitable franchise looks for a person with a dynamic and positive view towards life. It is a fact that the owner of this franchise is going to lead the next generation and one needs to be optimistic; hard working and educated to be that.', 2),
('Do I need to be flexible in order to lead the franchise?', 'Yes, one needs to be flexible and comfortable with different shifts throughout the day. The person may also need to correspond with different units located in alternative areas to keep up with the updates and developments of the services.', 3),
('What kind of experience is TechnoDome Institute looking for?', 'The experiences that TechnoDome Institute is looking for is nothing very special but effective. The person owning a franchise of this brand must expose managerial skills. He or she must also be adept in performing administrative tasks and managing human resource agendas.', 4),
('Does an individual need some sort of practical knowledge for this?', 'Of course! One must know about advanced information of the town or city where he or she might plan to purchase the franchise.', 5),
('What is the minimum area for the franchise?', 'The minimum area for the education franchise in India must be from 1000 sq. ft. to 1500 sq. ft. But, a larger area would be good for the centre as well.', 6);

INSERT INTO testimonials (name, location, testimonial, rating) VALUES
('Rajesh Kumar', 'Mumbai Center', 'Partnering with TechnoDome Institute was probably the best decision of my life. I have got the best business support and exposure only because of the brand value they carry.', 5),
('Priya Sharma', 'Delhi Center', 'I am privileged to work in partnership with TechnoDome Institute as it has given me a wide range of business scopes to explore. The training and support has been exceptional.', 5),
('Amit Patel', 'Bangalore Center', 'TechnoDome Institute proved itself to be the best. The expert faculty members are highly efficient in solving all my problems in a cooperative way. It proved for me as the most profitable franchise ever.', 5);

-- Insert default media gallery items
INSERT INTO media_gallery (title, description, media_type, file_url, order_index) VALUES
('Franchise Success Story', 'Watch how our franchise partners achieved success', 'video', 'https://www.youtube.com/watch?v=dQw4w9WgXcQ', 1),
('Student Testimonials', 'Hear from our successful students', 'video', 'https://www.youtube.com/watch?v=dQw4w9WgXcQ', 2),
('Center Tour', 'Take a virtual tour of our franchise centers', 'video', 'https://www.youtube.com/watch?v=dQw4w9WgXcQ', 3);
