<?php
include 'config.php';

// Handle form submissions
if ($_POST) {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'add_section':
                $section_name = mysqli_real_escape_string($conn, $_POST['section_name']);
                $section_type = mysqli_real_escape_string($conn, $_POST['section_type']);
                $title = mysqli_real_escape_string($conn, $_POST['title']);
                $content = mysqli_real_escape_string($conn, $_POST['content']);
                $order_index = (int)$_POST['order_index'];
                
                $query = "INSERT INTO sections (section_name, section_type, title, content, order_index) 
                         VALUES ('$section_name', '$section_type', '$title', '$content', '$order_index')";
                mysqli_query($conn, $query);
                break;
                
            case 'update_section':
                $id = (int)$_POST['id'];
                $section_name = mysqli_real_escape_string($conn, $_POST['section_name']);
                $title = mysqli_real_escape_string($conn, $_POST['title']);
                $content = mysqli_real_escape_string($conn, $_POST['content']);
                $order_index = (int)$_POST['order_index'];
                $is_active = isset($_POST['is_active']) ? 1 : 0;
                
                $query = "UPDATE sections SET section_name='$section_name', title='$title', content='$content', 
                         order_index='$order_index', is_active='$is_active' WHERE id='$id'";
                mysqli_query($conn, $query);
                break;
                
            case 'add_faq':
                $question = mysqli_real_escape_string($conn, $_POST['question']);
                $answer = mysqli_real_escape_string($conn, $_POST['answer']);
                $order_index = (int)$_POST['order_index'];
                
                $query = "INSERT INTO faq_items (question, answer, order_index) 
                         VALUES ('$question', '$answer', '$order_index')";
                mysqli_query($conn, $query);
                break;
                
            case 'update_faq':
                $id = (int)$_POST['id'];
                $question = mysqli_real_escape_string($conn, $_POST['question']);
                $answer = mysqli_real_escape_string($conn, $_POST['answer']);
                $order_index = (int)$_POST['order_index'];
                $is_active = isset($_POST['is_active']) ? 1 : 0;
                
                $query = "UPDATE faq_items SET question='$question', answer='$answer', 
                         order_index='$order_index', is_active='$is_active' WHERE id='$id'";
                mysqli_query($conn, $query);
                break;
                
            case 'add_testimonial':
                $name = mysqli_real_escape_string($conn, $_POST['name']);
                $location = mysqli_real_escape_string($conn, $_POST['location']);
                $testimonial = mysqli_real_escape_string($conn, $_POST['testimonial']);
                $rating = (int)$_POST['rating'];
                
                $query = "INSERT INTO testimonials (name, location, testimonial, rating) 
                         VALUES ('$name', '$location', '$testimonial', '$rating')";
                mysqli_query($conn, $query);
                break;
                
            case 'update_testimonial':
                $id = (int)$_POST['id'];
                $name = mysqli_real_escape_string($conn, $_POST['name']);
                $location = mysqli_real_escape_string($conn, $_POST['location']);
                $testimonial = mysqli_real_escape_string($conn, $_POST['testimonial']);
                $rating = (int)$_POST['rating'];
                $is_active = isset($_POST['is_active']) ? 1 : 0;
                
                $query = "UPDATE testimonials SET name='$name', location='$location', testimonial='$testimonial', 
                         rating='$rating', is_active='$is_active' WHERE id='$id'";
                mysqli_query($conn, $query);
                break;
                
            case 'add_media':
                $title = mysqli_real_escape_string($conn, $_POST['title']);
                $description = mysqli_real_escape_string($conn, $_POST['description']);
                $media_type = mysqli_real_escape_string($conn, $_POST['media_type']);
                $file_url = mysqli_real_escape_string($conn, $_POST['file_url']);
                $youtube_id = mysqli_real_escape_string($conn, $_POST['youtube_id']);
                $order_index = (int)$_POST['order_index'];
                
                $query = "INSERT INTO media_gallery (title, description, media_type, file_url, youtube_id, order_index) 
                         VALUES ('$title', '$description', '$media_type', '$file_url', '$youtube_id', '$order_index')";
                mysqli_query($conn, $query);
                break;
                
            case 'update_media':
                $id = (int)$_POST['id'];
                $title = mysqli_real_escape_string($conn, $_POST['title']);
                $description = mysqli_real_escape_string($conn, $_POST['description']);
                $media_type = mysqli_real_escape_string($conn, $_POST['media_type']);
                $file_url = mysqli_real_escape_string($conn, $_POST['file_url']);
                $youtube_id = mysqli_real_escape_string($conn, $_POST['youtube_id']);
                $order_index = (int)$_POST['order_index'];
                $is_active = isset($_POST['is_active']) ? 1 : 0;
                
                $query = "UPDATE media_gallery SET title='$title', description='$description', media_type='$media_type', 
                         file_url='$file_url', youtube_id='$youtube_id', order_index='$order_index', is_active='$is_active' WHERE id='$id'";
                mysqli_query($conn, $query);
                break;
                
            case 'delete_media':
                $id = (int)$_POST['id'];
                $query = "DELETE FROM media_gallery WHERE id='$id'";
                mysqli_query($conn, $query);
                break;
                
            case 'delete_section':
                $id = (int)$_POST['id'];
                $query = "DELETE FROM sections WHERE id='$id'";
                mysqli_query($conn, $query);
                break;
                
            case 'delete_faq':
                $id = (int)$_POST['id'];
                $query = "DELETE FROM faq_items WHERE id='$id'";
                mysqli_query($conn, $query);
                break;
                
            case 'delete_testimonial':
                $id = (int)$_POST['id'];
                $query = "DELETE FROM testimonials WHERE id='$id'";
                mysqli_query($conn, $query);
                break;
            case 'toggle_section_status':
                $id = (int)$_POST['id'];
                $status = (int)$_POST['status'];
                $query = "UPDATE sections SET is_active='$status' WHERE id='$id'";
                mysqli_query($conn, $query);
                echo json_encode(["success" => true, "status" => $status]);
                exit;
                
            case 'get_faq':
                $id = (int)$_POST['id'];
                $query = "SELECT * FROM faq_items WHERE id='$id'";
                $result = mysqli_query($conn, $query);
                if ($faq = mysqli_fetch_assoc($result)) {
                    echo json_encode(["success" => true, "faq" => $faq]);
                } else {
                    echo json_encode(["success" => false, "message" => "FAQ not found"]);
                }
                exit;

        }
    }
}

// Fetch data for display
$sections = mysqli_query($conn, "SELECT * FROM sections ORDER BY order_index ASC");
$faqs = mysqli_query($conn, "SELECT * FROM faq_items ORDER BY order_index ASC");
$testimonials = mysqli_query($conn, "SELECT * FROM testimonials ORDER BY created_at DESC");
$applications = mysqli_query($conn, "SELECT * FROM franchise_applications ORDER BY created_at DESC");
$media_gallery = mysqli_query($conn, "SELECT * FROM media_gallery ORDER BY order_index ASC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TechnoDome Franchise - Admin Panel</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Inter', sans-serif; background: #f8f9fa; }
        
        .header { background: linear-gradient(135deg, #ff6fb5, #8a5cf6); color: white; padding: 20px; }
        .header h1 { font-size: 24px; margin-bottom: 10px; }
        .header p { opacity: 0.9; }
        
        .container { max-width: 1200px; margin: 0 auto; padding: 20px; }
        
        .tabs { display: flex; background: white; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); margin-bottom: 20px; }
        .tab { padding: 15px 25px; cursor: pointer; border-bottom: 3px solid transparent; transition: all 0.3s; }
        .tab.active { border-bottom-color: #8a5cf6; background: #f8f9ff; }
        .tab:hover { background: #f8f9ff; }
        
        .tab-content { display: none; background: white; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); padding: 20px; }
        .tab-content.active { display: block; }
        
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 5px; font-weight: 600; color: #333; }
        .form-group input, .form-group textarea, .form-group select { 
            width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px; 
            font-size: 14px; transition: border-color 0.3s;
        }
        .form-group input:focus, .form-group textarea:focus, .form-group select:focus { 
            outline: none; border-color: #8a5cf6; 
        }
        .form-row { display: grid; grid-template-columns: 1fr 1fr; gap: 15px; }
        
        .btn { 
            background: linear-gradient(135deg, #ff6fb5, #8a5cf6); color: white; 
            padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; 
            font-weight: 600; transition: transform 0.2s;
        }
        .btn:hover { transform: translateY(-1px); }
        .btn-secondary { background: #6c757d; }
        .btn-danger { background: #dc3545; }
        .btn-sm { padding: 5px 10px; font-size: 12px; }
        
        .table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        .table th, .table td { padding: 12px; text-align: left; border-bottom: 1px solid #ddd; }
        .table th { background: #f8f9fa; font-weight: 600; }
        .table tr:hover { background: #f8f9fa; }
        
        .status-badge { 
            padding: 4px 8px; border-radius: 12px; font-size: 12px; font-weight: 600; 
        }
        .status-pending { background: #fff3cd; color: #856404; }
        .status-contacted { background: #d1ecf1; color: #0c5460; }
        .status-approved { background: #d4edda; color: #155724; }
        .status-rejected { background: #f8d7da; color: #721c24; }
        
        .modal { 
            display: none; position: fixed; z-index: 1000; left: 0; top: 0; 
            width: 100%; height: 100%; background: rgba(0,0,0,0.5); 
        }
        .modal-content { 
            background: white; margin: 5% auto; padding: 20px; border-radius: 8px; 
            width: 90%; max-width: 600px; max-height: 80vh; overflow-y: auto;
        }
        .modal-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .close { font-size: 24px; cursor: pointer; }
        
        .stats { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px; margin-bottom: 30px; }
        .stat-card { background: white; padding: 20px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); text-align: center; }
        .stat-number { font-size: 32px; font-weight: bold; color: #8a5cf6; }
        .stat-label { color: #666; margin-top: 5px; }
    </style>
</head>
<body>
    <div class="header">
        <div class="container">
            <h1>TechnoDome Franchise Admin Panel</h1>
            <p>Manage your franchise website content and applications</p>
        </div>
    </div>

    <div class="container">
        <div class="stats">
            <div class="stat-card">
                <div class="stat-number"><?php echo mysqli_num_rows($applications); ?></div>
                <div class="stat-label">Total Applications</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?php echo mysqli_num_rows($testimonials); ?></div>
                <div class="stat-label">Testimonials</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?php echo mysqli_num_rows($faqs); ?></div>
                <div class="stat-label">FAQ Items</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?php echo mysqli_num_rows($sections); ?></div>
                <div class="stat-label">Content Sections</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?php echo mysqli_num_rows($media_gallery); ?></div>
                <div class="stat-label">Media Items</div>
            </div>
        </div>

        <div class="tabs">
            <div class="tab active" onclick="showTab('applications')">Applications</div>
            <div class="tab" onclick="showTab('sections')">Content Sections</div>
            <div class="tab" onclick="showTab('faq')">FAQ Management</div>
            <div class="tab" onclick="showTab('testimonials')">Testimonials</div>
            <div class="tab" onclick="showTab('media')">Media Gallery</div>
        </div>

        <!-- Applications Tab -->
        <div id="applications" class="tab-content active">
            <h2>Franchise Applications</h2>
            <table class="table">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Location</th>
                        <th>Franchise Type</th>
                        <th>Status</th>
                        <th>Applied</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($app = mysqli_fetch_assoc($applications)): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($app['fullname']); ?></td>
                        <td><?php echo htmlspecialchars($app['email']); ?></td>
                        <td><?php echo htmlspecialchars($app['phone']); ?></td>
                        <td><?php echo htmlspecialchars($app['city'] . ', ' . $app['country']); ?></td>
                        <td><?php echo htmlspecialchars($app['franchise_type']); ?></td>
                        <td><span class="status-badge status-<?php echo $app['status']; ?>"><?php echo ucfirst($app['status']); ?></span></td>
                        <td><?php echo date('M d, Y', strtotime($app['created_at'])); ?></td>
                        <td>
                            <button class="btn btn-sm" onclick="viewApplication(<?php echo $app['id']; ?>)">View</button>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>

        <!-- Content Sections Tab -->
        <div id="sections" class="tab-content">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
                <h2>Content Sections</h2>
                <button class="btn" onclick="showModal('sectionModal')">Add New Section</button>
            </div>
            <table class="table">
                <thead>
                    <tr>
                        <th>Section Name</th>
                        <th>Type</th>
                        <th>Title</th>
                        <th>Order</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php mysqli_data_seek($sections, 0); while ($section = mysqli_fetch_assoc($sections)): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($section['section_name']); ?></td>
                        <td><?php echo htmlspecialchars($section['section_type']); ?></td>
                        <td><?php echo htmlspecialchars($section['title']); ?></td>
                        <td><?php echo $section['order_index']; ?></td>
                        <td>
                            <button class="btn btn-sm toggle-status" 
                                data-id="<?php echo $section['id']; ?>">
                                <?php echo $section['is_active'] ? 'Deactivate' : 'Activate'; ?>
                            </button>
                        </td>

                        <td>
                            <button class="btn btn-sm" onclick="editSection(<?php echo $section['id']; ?>)">Edit</button>
                            <button class="btn btn-sm btn-danger" onclick="deleteSection(<?php echo $section['id']; ?>)">Delete</button>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>

        <!-- FAQ Tab -->
        <div id="faq" class="tab-content">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
                <h2>FAQ Management</h2>
                <button class="btn" onclick="addNewFaq()">Add New FAQ</button>
            </div>
            <table class="table">
                <thead>
                    <tr>
                        <th>Question</th>
                        <th>Order</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($faq = mysqli_fetch_assoc($faqs)): ?>
                    <tr>
                        <td><?php echo htmlspecialchars(substr($faq['question'], 0, 50)) . '...'; ?></td>
                        <td><?php echo $faq['order_index']; ?></td>
                        <td><?php echo $faq['is_active'] ? 'Active' : 'Inactive'; ?></td>
                        <td>
                            <button class="btn btn-sm" onclick="editFaq(<?php echo $faq['id']; ?>)">Edit</button>
                            <button class="btn btn-sm btn-danger" onclick="deleteFaq(<?php echo $faq['id']; ?>)">Delete</button>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>

        <!-- Testimonials Tab -->
        <div id="testimonials" class="tab-content">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
                <h2>Testimonials</h2>
                <button class="btn" onclick="showModal('testimonialModal')">Add New Testimonial</button>
            </div>
            <table class="table">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Location</th>
                        <th>Rating</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($testimonial = mysqli_fetch_assoc($testimonials)): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($testimonial['name']); ?></td>
                        <td><?php echo htmlspecialchars($testimonial['location']); ?></td>
                        <td><?php echo $testimonial['rating']; ?> ⭐</td>
                        <td><?php echo $testimonial['is_active'] ? 'Active' : 'Inactive'; ?></td>
                        <td>
                            <button class="btn btn-sm" onclick="editTestimonial(<?php echo $testimonial['id']; ?>)">Edit</button>
                            <button class="btn btn-sm btn-danger" onclick="deleteTestimonial(<?php echo $testimonial['id']; ?>)">Delete</button>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>

        <!-- Media Gallery Tab -->
        <div id="media" class="tab-content">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
                <h2>Media Gallery</h2>
                <button class="btn" onclick="showModal('mediaModal')">Add New Media</button>
            </div>
            <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 20px;">
                <?php mysqli_data_seek($media_gallery, 0); while ($media = mysqli_fetch_assoc($media_gallery)): ?>
                <div style="background: white; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); overflow: hidden;">
                    <?php if ($media['media_type'] == 'video'): ?>
                        <div style="position: relative; padding-bottom: 56.25%; background: #f0f0f0;">
                            <?php if ($media['youtube_id']): ?>
                                <iframe width="100%" height="100%" src="https://www.youtube.com/embed/<?php echo $media['youtube_id']; ?>" 
                                        frameborder="0" allowfullscreen style="position: absolute; top: 0; left: 0;"></iframe>
                            <?php else: ?>
                                <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); color: #666;">
                                    <i style="font-size: 48px;">▶️</i>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php else: ?>
                        <img src="<?php echo htmlspecialchars($media['file_url']); ?>" alt="<?php echo htmlspecialchars($media['title']); ?>" 
                             style="width: 100%; height: 200px; object-fit: cover;">
                    <?php endif; ?>
                    <div style="padding: 15px;">
                        <h4 style="margin: 0 0 8px; color: #333;"><?php echo htmlspecialchars($media['title']); ?></h4>
                        <p style="margin: 0 0 10px; color: #666; font-size: 14px;"><?php echo htmlspecialchars($media['description']); ?></p>
                        <div style="display: flex; justify-content: space-between; align-items: center;">
                            <span style="background: #e3f2fd; color: #1976d2; padding: 4px 8px; border-radius: 12px; font-size: 12px; font-weight: 600;">
                                <?php echo ucfirst($media['media_type']); ?>
                            </span>
                            <div>
                                <button class="btn btn-sm" onclick="editMedia(<?php echo $media['id']; ?>)">Edit</button>
                                <button class="btn btn-sm btn-danger" onclick="deleteMedia(<?php echo $media['id']; ?>)">Delete</button>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endwhile; ?>
            </div>
        </div>
    </div>

    <!-- Section Modal -->
    <div id="sectionModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Add/Edit Section</h3>
                <span class="close" onclick="closeModal('sectionModal')">&times;</span>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="add_section">
                <input type="hidden" name="id" id="section_id">
                <div class="form-group">
                    <label>Section Name</label>
                    <input type="text" name="section_name" id="section_name" required>
                </div>
                <div class="form-group">
                    <label>Section Type</label>
                    <select name="section_type" id="section_type" required>
                        <option value="hero">Hero</option>
                        <option value="benefits">Benefits</option>
                        <option value="process">Process</option>
                        <option value="investment">Investment</option>
                        <option value="requirements">Requirements</option>
                        <option value="faq">FAQ</option>
                        <option value="testimonials">Testimonials</option>
                        <option value="contact">Contact</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>Title</label>
                    <input type="text" name="title" id="section_title" required>
                </div>
                <div class="form-group">
                    <label>Content</label>
                    <textarea name="content" id="section_content" rows="5" required></textarea>
                </div>
                <div class="form-group">
                    <label>Order Index</label>
                    <input type="number" name="order_index" id="section_order" value="1">
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" name="is_active" id="section_active" checked> Active
                    </label>
                </div>
                <button type="submit" class="btn">Save Section</button>
            </form>
        </div>
    </div>

    <!-- FAQ Modal -->
    <div id="faqModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Add/Edit FAQ</h3>
                <span class="close" onclick="closeModal('faqModal')">&times;</span>
            </div>
            <form method="POST" id="faqForm">
                <input type="hidden" name="action" id="faq_action" value="add_faq">
                <input type="hidden" name="id" id="faq_id">
                <div class="form-group">
                    <label>Question</label>
                    <input type="text" name="question" id="faq_question" required>
                </div>
                <div class="form-group">
                    <label>Answer</label>
                    <textarea name="answer" id="faq_answer" rows="4" required></textarea>
                </div>
                <div class="form-group">
                    <label>Order Index</label>
                    <input type="number" name="order_index" id="faq_order" value="1">
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" name="is_active" id="faq_active" checked> Active
                    </label>
                </div>
                <button type="submit" class="btn" id="faqSubmitBtn">Save FAQ</button>
            </form>
        </div>
    </div>


    <!-- Testimonial Modal -->
    <div id="testimonialModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Add/Edit Testimonial</h3>
                <span class="close" onclick="closeModal('testimonialModal')">&times;</span>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="add_testimonial">
                <input type="hidden" name="id" id="testimonial_id">
                <div class="form-row">
                    <div class="form-group">
                        <label>Name</label>
                        <input type="text" name="name" id="testimonial_name" required>
                    </div>
                    <div class="form-group">
                        <label>Location</label>
                        <input type="text" name="location" id="testimonial_location" required>
                    </div>
                </div>
                <div class="form-group">
                    <label>Testimonial</label>
                    <textarea name="testimonial" id="testimonial_text" rows="4" required></textarea>
                </div>
                <div class="form-group">
                    <label>Rating</label>
                    <select name="rating" id="testimonial_rating">
                        <option value="5">5 Stars</option>
                        <option value="4">4 Stars</option>
                        <option value="3">3 Stars</option>
                        <option value="2">2 Stars</option>
                        <option value="1">1 Star</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" name="is_active" id="testimonial_active" checked> Active
                    </label>
                </div>
                <button type="submit" class="btn">Save Testimonial</button>
            </form>
        </div>
    </div>

    <!-- Media Modal -->
    <div id="mediaModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Add/Edit Media</h3>
                <span class="close" onclick="closeModal('mediaModal')">&times;</span>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="add_media">
                <input type="hidden" name="id" id="media_id">
                <div class="form-group">
                    <label>Title</label>
                    <input type="text" name="title" id="media_title" required>
                </div>
                <div class="form-group">
                    <label>Description</label>
                    <textarea name="description" id="media_description" rows="3"></textarea>
                </div>
                <div class="form-group">
                    <label>Media Type</label>
                    <select name="media_type" id="media_type" onchange="toggleMediaFields()">
                        <option value="image">Image</option>
                        <option value="video">Video</option>
                    </select>
                </div>
                <div class="form-group" id="image_field">
                    <label>Image URL</label>
                    <input type="url" name="file_url" id="media_file_url" placeholder="https://example.com/image.jpg">
                </div>
                <div class="form-group" id="video_field" style="display: none;">
                    <label>YouTube Video URL</label>
                    <input type="url" name="file_url" id="media_video_url" placeholder="https://www.youtube.com/watch?v=VIDEO_ID">
                    <small style="color: #666; font-size: 12px;">Paste the full YouTube URL</small>
                </div>
                <div class="form-group" id="youtube_id_field" style="display: none;">
                    <label>YouTube Video ID</label>
                    <input type="text" name="youtube_id" id="media_youtube_id" placeholder="dQw4w9WgXcQ">
                    <small style="color: #666; font-size: 12px;">Extracted automatically from URL</small>
                </div>
                <div class="form-group">
                    <label>Order Index</label>
                    <input type="number" name="order_index" id="media_order" value="1">
                </div>
                <div class="form-group">
                    <label>
                        <input type="checkbox" name="is_active" id="media_active" checked> Active
                    </label>
                </div>
                <button type="submit" class="btn">Save Media</button>
            </form>
        </div>
    </div>

    <script>
        function showTab(tabName) {
            // Hide all tab contents
            document.querySelectorAll('.tab-content').forEach(tab => {
                tab.classList.remove('active');
            });
            
            // Remove active class from all tabs
            document.querySelectorAll('.tab').forEach(tab => {
                tab.classList.remove('active');
            });
            
            // Show selected tab content
            document.getElementById(tabName).classList.add('active');
            
            // Add active class to clicked tab
            event.target.classList.add('active');
        }

        function showModal(modalId) {
            document.getElementById(modalId).style.display = 'block';
        }

        function closeModal(modalId) {
            document.getElementById(modalId).style.display = 'none';
        }

        function editSection(id) {
            // This would typically fetch data via AJAX and populate the form
            showModal('sectionModal');
        }

        function addNewFaq() {
            // Reset form for adding new FAQ
            document.getElementById('faq_action').value = 'add_faq';
            document.getElementById('faq_id').value = '';
            document.getElementById('faq_question').value = '';
            document.getElementById('faq_answer').value = '';
            document.getElementById('faq_order').value = '1';
            document.getElementById('faq_active').checked = true;
            document.getElementById('faqSubmitBtn').textContent = 'Save FAQ';
            showModal('faqModal');
        }

        function editFaq(id) {
            // Fetch FAQ data and populate the form
            fetch('', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: 'action=get_faq&id=' + id
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById('faq_action').value = 'update_faq';
                    document.getElementById('faq_id').value = data.faq.id;
                    document.getElementById('faq_question').value = data.faq.question;
                    document.getElementById('faq_answer').value = data.faq.answer;
                    document.getElementById('faq_order').value = data.faq.order_index;
                    document.getElementById('faq_active').checked = data.faq.is_active == 1;
                    document.getElementById('faqSubmitBtn').textContent = 'Update FAQ';
                    showModal('faqModal');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Error loading FAQ data');
            });
        }

        function editTestimonial(id) {
            showModal('testimonialModal');
        }

        function editMedia(id) {
            showModal('mediaModal');
        }

        function deleteMedia(id) {
            if (confirm('Are you sure you want to delete this media item?')) {
                const form = document.createElement('form');
                form.method = 'POST';
                form.innerHTML = `
                    <input type="hidden" name="action" value="delete_media">
                    <input type="hidden" name="id" value="${id}">
                `;
                document.body.appendChild(form);
                form.submit();
            }
        }

        function deleteSection(id) {
            if (confirm('Are you sure you want to delete this section?')) {
                const form = document.createElement('form');
                form.method = 'POST';
                form.innerHTML = `
                    <input type="hidden" name="action" value="delete_section">
                    <input type="hidden" name="id" value="${id}">
                `;
                document.body.appendChild(form);
                form.submit();
            }
        }

        function deleteFaq(id) {
            if (confirm('Are you sure you want to delete this FAQ?')) {
                const form = document.createElement('form');
                form.method = 'POST';
                form.innerHTML = `
                    <input type="hidden" name="action" value="delete_faq">
                    <input type="hidden" name="id" value="${id}">
                `;
                document.body.appendChild(form);
                form.submit();
            }
        }

        function deleteTestimonial(id) {
            if (confirm('Are you sure you want to delete this testimonial?')) {
                const form = document.createElement('form');
                form.method = 'POST';
                form.innerHTML = `
                    <input type="hidden" name="action" value="delete_testimonial">
                    <input type="hidden" name="id" value="${id}">
                `;
                document.body.appendChild(form);
                form.submit();
            }
        }

        function toggleMediaFields() {
            const mediaType = document.getElementById('media_type').value;
            const imageField = document.getElementById('image_field');
            const videoField = document.getElementById('video_field');
            const youtubeIdField = document.getElementById('youtube_id_field');
            
            if (mediaType === 'image') {
                imageField.style.display = 'block';
                videoField.style.display = 'none';
                youtubeIdField.style.display = 'none';
            } else if (mediaType === 'video') {
                imageField.style.display = 'none';
                videoField.style.display = 'block';
                youtubeIdField.style.display = 'block';
            }
        }

        // Auto-extract YouTube ID from URL
        document.getElementById('media_video_url').addEventListener('input', function() {
            const url = this.value;
            const youtubeId = extractYouTubeId(url);
            if (youtubeId) {
                document.getElementById('media_youtube_id').value = youtubeId;
            }
        });
            document.querySelectorAll('.toggle-status').forEach(button => {
            button.addEventListener('click', function () {
                const id = this.getAttribute('data-id');
                const currentStatus = this.getAttribute('data-status');
                const newStatus = currentStatus == "1" ? 0 : 1;

                fetch("", {
                    method: "POST",
                    headers: { "Content-Type": "application/x-www-form-urlencoded" },
                    body: "action=toggle_section_status&id=" + id + "&status=" + newStatus
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        this.setAttribute('data-status', newStatus);
                        this.textContent = newStatus == 1 ? "Deactivate" : "Activate";
                        this.closest("tr").querySelector("td:nth-child(5)").textContent = newStatus == 1 ? "Active" : "Inactive";
                    }
                });
            });
        });

        function extractYouTubeId(url) {
            const regExp = /^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|&v=)([^#&?]*).*/;
            const match = url.match(regExp);
            return (match && match[2].length === 11) ? match[2] : null;
        }

        function viewApplication(id) {
            // This would show application details
            alert('View application details for ID: ' + id);
        }

        // Close modal when clicking outside
        window.onclick = function(event) {
            if (event.target.classList.contains('modal')) {
                event.target.style.display = 'none';
            }
        }
    </script>
</body>
</html>
