<?php
include 'includes/header.php';
?>

<!-- Testimonials Tab -->
<div id="testimonials" class="tab-content active">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
        <h2>Testimonials</h2>
        <button class="btn" onclick="showModal('testimonialModal')">Add New Testimonial</button>
    </div>
    <table class="table">
        <thead>
            <tr>
                <th>Name</th>
                <th>Location</th>
                <th>Rating</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($testimonial = mysqli_fetch_assoc($testimonials)): ?>
            <tr>
                <td><?php echo htmlspecialchars($testimonial['name']); ?></td>
                <td><?php echo htmlspecialchars($testimonial['location']); ?></td>
                <td><?php echo $testimonial['rating']; ?> ⭐</td>
                <td><?php echo $testimonial['is_active'] ? 'Active' : 'Inactive'; ?></td>
                <td>
                    <button class="btn btn-sm" onclick="editTestimonial(<?php echo $testimonial['id']; ?>)">Edit</button>
                    <button class="btn btn-sm btn-danger" onclick="deleteTestimonial(<?php echo $testimonial['id']; ?>)">Delete</button>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>

<!-- Testimonial Modal -->
<div id="testimonialModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h3>Add/Edit Testimonial</h3>
            <span class="close" onclick="closeModal('testimonialModal')">&times;</span>
        </div>
        <form method="POST">
            <input type="hidden" name="action" value="add_testimonial">
            <input type="hidden" name="id" id="testimonial_id">
            <div class="form-row">
                <div class="form-group">
                    <label>Name</label>
                    <input type="text" name="name" id="testimonial_name" required>
                </div>
                <div class="form-group">
                    <label>Location</label>
                    <input type="text" name="location" id="testimonial_location" required>
                </div>
            </div>
            <div class="form-group">
                <label>Testimonial</label>
                <textarea name="testimonial" id="testimonial_text" rows="4" required></textarea>
            </div>
            <div class="form-group">
                <label>Rating</label>
                <select name="rating" id="testimonial_rating">
                    <option value="5">5 Stars</option>
                    <option value="4">4 Stars</option>
                    <option value="3">3 Stars</option>
                    <option value="2">2 Stars</option>
                    <option value="1">1 Star</option>
                </select>
            </div>
            <div class="form-group">
                <label>
                    <input type="checkbox" name="is_active" id="testimonial_active" checked> Active
                </label>
            </div>
            <button type="submit" class="btn">Save Testimonial</button>
        </form>
    </div>
</div>

<?php include 'includes/footer.php'; ?>