<?php
include 'includes/header.php';
?>

<!-- Content Sections Tab -->
<div id="sections" class="tab-content active">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
        <h2>Content Sections</h2>
        <button class="btn" onclick="addNewSection()">Add New Section</button>
    </div>
    <table class="table">
        <thead>
            <tr>
                <th>Section Name</th>
                <th>Type</th>
                <th>Title</th>
                <th>Order</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            // Debug: Check if sections query has results
            if (mysqli_num_rows($sections) == 0) {
                echo '<tr><td colspan="6" style="text-align: center; padding: 20px; color: #666;">No sections found. <a href="#" onclick="addNewSection()">Add your first section</a></td></tr>';
            } else {
                mysqli_data_seek($sections, 0); 
                while ($section = mysqli_fetch_assoc($sections)): 
            ?>
            <tr>
                <td><?php echo htmlspecialchars($section['section_name']); ?></td>
                <td><?php echo htmlspecialchars($section['section_type']); ?></td>
                <td><?php echo htmlspecialchars($section['title']); ?></td>
                <td><?php echo $section['order_index']; ?></td>
                <td>
                    <button class="btn btn-sm toggle-status" 
                        data-id="<?php echo $section['id']; ?>">
                        <?php echo $section['is_active'] ? 'Deactivate' : 'Activate'; ?>
                    </button>
                </td>
                <td>
                    <button class="btn btn-sm" onclick="editSection(<?php echo $section['id']; ?>)">Edit</button>
                    <button class="btn btn-sm btn-danger" onclick="deleteSection(<?php echo $section['id']; ?>)">Delete</button>
                </td>
            </tr>
            <?php 
                endwhile; 
            }
            ?>
        </tbody>
    </table>
</div>

<!-- Section Modal -->
<div id="sectionModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h3>Add/Edit Section</h3>
            <span class="close" onclick="closeModal('sectionModal')">&times;</span>
        </div>
        <form method="POST" id="sectionForm">
            <input type="hidden" name="action" id="section_action" value="add_section">
            <input type="hidden" name="id" id="section_id">
            <div class="form-group">
                <label>Section Name</label>
                <input type="text" name="section_name" id="section_name" required>
            </div>
            <div class="form-group">
                <label>Section Type</label>
                <select name="section_type" id="section_type" required>
                    <option value="hero">Hero</option>
                    <option value="benefits">Benefits</option>
                    <option value="process">Process</option>
                    <option value="investment">Investment</option>
                    <option value="requirements">Requirements</option>
                    <option value="faq">FAQ</option>
                    <option value="testimonials">Testimonials</option>
                    <option value="contact">Contact</option>
                </select>
            </div>
            <div class="form-group">
                <label>Title</label>
                <input type="text" name="title" id="section_title" required>
            </div>
            <div class="form-group">
                <label>Content</label>
                <textarea name="content" id="section_content" rows="5" required></textarea>
            </div>
            <div class="form-group">
                <label>Order Index</label>
                <input type="number" name="order_index" id="section_order" value="1">
            </div>
            <div class="form-group">
                <label>
                    <input type="checkbox" name="is_active" id="section_active" checked> Active
                </label>
            </div>
            <button type="submit" class="btn" id="sectionSubmitBtn">Save Section</button>
        </form>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
