<?php
include 'includes/header.php';
?>

<!-- Media Gallery Tab -->
<div id="media" class="tab-content active">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
        <h2>Media Gallery</h2>
        <button class="btn" onclick="showModal('mediaModal')">Add New Media</button>
    </div>
    <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 20px;">
        <?php mysqli_data_seek($media_gallery, 0); while ($media = mysqli_fetch_assoc($media_gallery)): ?>
        <div style="background: white; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); overflow: hidden;">
            <?php if ($media['media_type'] == 'video'): ?>
                <div style="position: relative; padding-bottom: 56.25%; background: #f0f0f0;">
                    <?php if ($media['youtube_id']): ?>
                        <iframe width="100%" height="100%" src="https://www.youtube.com/embed/<?php echo $media['youtube_id']; ?>" 
                                frameborder="0" allowfullscreen style="position: absolute; top: 0; left: 0;"></iframe>
                    <?php else: ?>
                        <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); color: #666;">
                            <i style="font-size: 48px;">▶️</i>
                        </div>
                    <?php endif; ?>
                </div>
            <?php else: ?>
                <img src="<?php echo htmlspecialchars($media['file_url']); ?>" alt="<?php echo htmlspecialchars($media['title']); ?>" 
                     style="width: 100%; height: 200px; object-fit: cover;">
            <?php endif; ?>
            <div style="padding: 15px;">
                <h4 style="margin: 0 0 8px; color: #333;"><?php echo htmlspecialchars($media['title']); ?></h4>
                <p style="margin: 0 0 10px; color: #666; font-size: 14px;"><?php echo htmlspecialchars($media['description']); ?></p>
                <div style="display: flex; justify-content: space-between; align-items: center;">
                    <span style="background: #e3f2fd; color: #1976d2; padding: 4px 8px; border-radius: 12px; font-size: 12px; font-weight: 600;">
                        <?php echo ucfirst($media['media_type']); ?>
                    </span>
                    <div>
                        <button class="btn btn-sm" onclick="editMedia(<?php echo $media['id']; ?>)">Edit</button>
                        <button class="btn btn-sm btn-danger" onclick="deleteMedia(<?php echo $media['id']; ?>)">Delete</button>
                    </div>
                </div>
            </div>
        </div>
        <?php endwhile; ?>
    </div>
</div>

<!-- Media Modal -->
<div id="mediaModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h3>Add/Edit Media</h3>
            <span class="close" onclick="closeModal('mediaModal')">&times;</span>
        </div>
        <form method="POST">
            <input type="hidden" name="action" value="add_media">
            <input type="hidden" name="id" id="media_id">
            <div class="form-group">
                <label>Title</label>
                <input type="text" name="title" id="media_title" required>
            </div>
            <div class="form-group">
                <label>Description</label>
                <textarea name="description" id="media_description" rows="3"></textarea>
            </div>
            <div class="form-group">
                <label>Media Type</label>
                <select name="media_type" id="media_type" onchange="toggleMediaFields()">
                    <option value="image">Image</option>
                    <option value="video">Video</option>
                </select>
            </div>
            <div class="form-group" id="image_field">
                <label>Image URL</label>
                <input type="url" name="file_url" id="media_file_url" placeholder="https://example.com/image.jpg">
            </div>
            <div class="form-group" id="video_field" style="display: none;">
                <label>YouTube Video URL</label>
                <input type="url" name="file_url" id="media_video_url" placeholder="https://www.youtube.com/watch?v=VIDEO_ID">
                <small style="color: #666; font-size: 12px;">Paste the full YouTube URL</small>
            </div>
            <div class="form-group" id="youtube_id_field" style="display: none;">
                <label>YouTube Video ID</label>
                <input type="text" name="youtube_id" id="media_youtube_id" placeholder="dQw4w9WgXcQ">
                <small style="color: #666; font-size: 12px;">Extracted automatically from URL</small>
            </div>
            <div class="form-group">
                <label>Order Index</label>
                <input type="number" name="order_index" id="media_order" value="1">
            </div>
            <div class="form-group">
                <label>
                    <input type="checkbox" name="is_active" id="media_active" checked> Active
                </label>
            </div>
            <button type="submit" class="btn">Save Media</button>
        </form>
    </div>
</div>

<?php include 'includes/footer.php'; ?>