<?php
include 'includes/header.php';
?>

<!-- Applications Tab -->
<div id="applications" class="tab-content active">
    <h2>Franchise Applications</h2>
    <table class="table">
        <thead>
            <tr>
                <th>Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Location</th>
                <th>Franchise Type</th>
                <th>Status</th>
                <th>Applied</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($app = mysqli_fetch_assoc($applications)): ?>
            <tr>
                <td><?php echo htmlspecialchars($app['fullname']); ?></td>
                <td><?php echo htmlspecialchars($app['email']); ?></td>
                <td><?php echo htmlspecialchars($app['phone']); ?></td>
                <td><?php echo htmlspecialchars($app['city'] . ', ' . $app['country']); ?></td>
                <td><?php echo htmlspecialchars($app['franchise_type']); ?></td>
                <td><span class="status-badge status-<?php echo $app['status']; ?>"><?php echo ucfirst($app['status']); ?></span></td>
                <td><?php echo date('M d, Y', strtotime($app['created_at'])); ?></td>
                <td>
                    <button class="btn btn-sm" onclick="viewApplication(<?php echo $app['id']; ?>)">View</button>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>
