<?php
include '../config.php';

// Handle form submissions
if ($_POST) {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'add_section':
                $section_name = mysqli_real_escape_string($conn, $_POST['section_name']);
                $section_type = mysqli_real_escape_string($conn, $_POST['section_type']);
                $title = mysqli_real_escape_string($conn, $_POST['title']);
                $content = mysqli_real_escape_string($conn, $_POST['content']);
                $order_index = (int)$_POST['order_index'];
                
                $query = "INSERT INTO sections (section_name, section_type, title, content, order_index) 
                         VALUES ('$section_name', '$section_type', '$title', '$content', '$order_index')";
                mysqli_query($conn, $query);
                break;
                
            case 'update_section':
                $id = (int)$_POST['id'];
                $section_name = mysqli_real_escape_string($conn, $_POST['section_name']);
                $title = mysqli_real_escape_string($conn, $_POST['title']);
                $content = mysqli_real_escape_string($conn, $_POST['content']);
                $order_index = (int)$_POST['order_index'];
                $is_active = isset($_POST['is_active']) ? 1 : 0;
                
                $query = "UPDATE sections SET section_name='$section_name', title='$title', content='$content', 
                         order_index='$order_index', is_active='$is_active' WHERE id='$id'";
                mysqli_query($conn, $query);
                break;
                
            case 'add_faq':
                $question = mysqli_real_escape_string($conn, $_POST['question']);
                $answer = mysqli_real_escape_string($conn, $_POST['answer']);
                $order_index = (int)$_POST['order_index'];
                
                $query = "INSERT INTO faq_items (question, answer, order_index) 
                         VALUES ('$question', '$answer', '$order_index')";
                mysqli_query($conn, $query);
                break;
                
            case 'update_faq':
                $id = (int)$_POST['id'];
                $question = mysqli_real_escape_string($conn, $_POST['question']);
                $answer = mysqli_real_escape_string($conn, $_POST['answer']);
                $order_index = (int)$_POST['order_index'];
                $is_active = isset($_POST['is_active']) ? 1 : 0;
                
                $query = "UPDATE faq_items SET question='$question', answer='$answer', 
                         order_index='$order_index', is_active='$is_active' WHERE id='$id'";
                mysqli_query($conn, $query);
                break;
                
            case 'add_testimonial':
                $name = mysqli_real_escape_string($conn, $_POST['name']);
                $location = mysqli_real_escape_string($conn, $_POST['location']);
                $testimonial = mysqli_real_escape_string($conn, $_POST['testimonial']);
                $rating = (int)$_POST['rating'];
                
                $query = "INSERT INTO testimonials (name, location, testimonial, rating) 
                         VALUES ('$name', '$location', '$testimonial', '$rating')";
                mysqli_query($conn, $query);
                break;
                
            case 'update_testimonial':
                $id = (int)$_POST['id'];
                $name = mysqli_real_escape_string($conn, $_POST['name']);
                $location = mysqli_real_escape_string($conn, $_POST['location']);
                $testimonial = mysqli_real_escape_string($conn, $_POST['testimonial']);
                $rating = (int)$_POST['rating'];
                $is_active = isset($_POST['is_active']) ? 1 : 0;
                
                $query = "UPDATE testimonials SET name='$name', location='$location', testimonial='$testimonial', 
                         rating='$rating', is_active='$is_active' WHERE id='$id'";
                mysqli_query($conn, $query);
                break;
                
            case 'add_media':
                $title = mysqli_real_escape_string($conn, $_POST['title']);
                $description = mysqli_real_escape_string($conn, $_POST['description']);
                $media_type = mysqli_real_escape_string($conn, $_POST['media_type']);
                $file_url = mysqli_real_escape_string($conn, $_POST['file_url']);
                $youtube_id = mysqli_real_escape_string($conn, $_POST['youtube_id']);
                $order_index = (int)$_POST['order_index'];
                
                $query = "INSERT INTO media_gallery (title, description, media_type, file_url, youtube_id, order_index) 
                         VALUES ('$title', '$description', '$media_type', '$file_url', '$youtube_id', '$order_index')";
                mysqli_query($conn, $query);
                break;
                
            case 'update_media':
                $id = (int)$_POST['id'];
                $title = mysqli_real_escape_string($conn, $_POST['title']);
                $description = mysqli_real_escape_string($conn, $_POST['description']);
                $media_type = mysqli_real_escape_string($conn, $_POST['media_type']);
                $file_url = mysqli_real_escape_string($conn, $_POST['file_url']);
                $youtube_id = mysqli_real_escape_string($conn, $_POST['youtube_id']);
                $order_index = (int)$_POST['order_index'];
                $is_active = isset($_POST['is_active']) ? 1 : 0;
                
                $query = "UPDATE media_gallery SET title='$title', description='$description', media_type='$media_type', 
                         file_url='$file_url', youtube_id='$youtube_id', order_index='$order_index', is_active='$is_active' WHERE id='$id'";
                mysqli_query($conn, $query);
                break;
                
            case 'delete_media':
                $id = (int)$_POST['id'];
                $query = "DELETE FROM media_gallery WHERE id='$id'";
                mysqli_query($conn, $query);
                break;
                
            case 'delete_section':
                $id = (int)$_POST['id'];
                $query = "DELETE FROM sections WHERE id='$id'";
                mysqli_query($conn, $query);
                break;
                
            case 'delete_faq':
                $id = (int)$_POST['id'];
                $query = "DELETE FROM faq_items WHERE id='$id'";
                mysqli_query($conn, $query);
                break;
                
            case 'delete_testimonial':
                $id = (int)$_POST['id'];
                $query = "DELETE FROM testimonials WHERE id='$id'";
                mysqli_query($conn, $query);
                break;
                
            case 'toggle_section_status':
                $id = (int)$_POST['id'];
                $status = (int)$_POST['status'];
                $query = "UPDATE sections SET is_active='$status' WHERE id='$id'";
                mysqli_query($conn, $query);
                echo json_encode(["success" => true, "status" => $status]);
                exit;
                
            case 'get_faq':
                $id = (int)$_POST['id'];
                $query = "SELECT * FROM faq_items WHERE id='$id'";
                $result = mysqli_query($conn, $query);
                if ($faq = mysqli_fetch_assoc($result)) {
                    echo json_encode(["success" => true, "faq" => $faq]);
                } else {
                    echo json_encode(["success" => false, "message" => "FAQ not found"]);
                }
                exit;
                
            case 'get_section':
                $id = (int)$_POST['id'];
                $query = "SELECT * FROM sections WHERE id='$id'";
                $result = mysqli_query($conn, $query);
                
                // Debug: Check for database errors
                if (!$result) {
                    echo json_encode(["success" => false, "message" => "Database error: " . mysqli_error($conn)]);
                    exit;
                }
                
                if ($section = mysqli_fetch_assoc($result)) {
                    // Clean the data to prevent JSON corruption
                    $clean_section = array();
                    foreach ($section as $key => $value) {
                        // Remove any null bytes and clean the data
                        $clean_section[$key] = str_replace("\0", "", $value);
                        // Ensure proper encoding
                        $clean_section[$key] = mb_convert_encoding($clean_section[$key], 'UTF-8', 'UTF-8');
                    }
                    
                    // Set proper headers for JSON response
                    header('Content-Type: application/json; charset=utf-8');
                    echo json_encode(["success" => true, "section" => $clean_section], JSON_UNESCAPED_UNICODE);
                } else {
                    echo json_encode(["success" => false, "message" => "Section not found with ID: " . $id]);
                }
                exit;
        }
    }
}

// Fetch data for display
$sections = mysqli_query($conn, "SELECT * FROM sections ORDER BY order_index ASC");
$faqs = mysqli_query($conn, "SELECT * FROM faq_items ORDER BY order_index ASC");
$testimonials = mysqli_query($conn, "SELECT * FROM testimonials ORDER BY created_at DESC");
$applications = mysqli_query($conn, "SELECT * FROM franchise_applications ORDER BY created_at DESC");
$media_gallery = mysqli_query($conn, "SELECT * FROM media_gallery ORDER BY order_index ASC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TechnoDome Franchise - Admin Panel</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Inter', sans-serif; background: #f8f9fa; }
        
        .header { background: linear-gradient(135deg, #ff6fb5, #8a5cf6); color: white; padding: 20px; }
        .header h1 { font-size: 24px; margin-bottom: 10px; }
        .header p { opacity: 0.9; }
        
        .container { max-width: 1200px; margin: 0 auto; padding: 20px; }
        
        .tabs { display: flex; background: white; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); margin-bottom: 20px; }
        .tab { padding: 15px 25px; cursor: pointer; border-bottom: 3px solid transparent; transition: all 0.3s; text-decoration: none; color: #333; display: block; }
        .tab.active { border-bottom-color: #8a5cf6; background: #f8f9ff; }
        .tab:hover { background: #f8f9ff; text-decoration: none; color: #333; }
        
        .tab-content { display: none; background: white; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); padding: 20px; }
        .tab-content.active { display: block; }
        
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 5px; font-weight: 600; color: #333; }
        .form-group input, .form-group textarea, .form-group select { 
            width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px; 
            font-size: 14px; transition: border-color 0.3s;
        }
        .form-group input:focus, .form-group textarea:focus, .form-group select:focus { 
            outline: none; border-color: #8a5cf6; 
        }
        .form-row { display: grid; grid-template-columns: 1fr 1fr; gap: 15px; }
        
        .btn { 
            background: linear-gradient(135deg, #ff6fb5, #8a5cf6); color: white; 
            padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; 
            font-weight: 600; transition: transform 0.2s;
        }
        .btn:hover { transform: translateY(-1px); }
        .btn-secondary { background: #6c757d; }
        .btn-danger { background: #dc3545; }
        .btn-sm { padding: 5px 10px; font-size: 12px; }
        
        .table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        .table th, .table td { padding: 12px; text-align: left; border-bottom: 1px solid #ddd; }
        .table th { background: #f8f9fa; font-weight: 600; }
        .table tr:hover { background: #f8f9fa; }
        
        .status-badge { 
            padding: 4px 8px; border-radius: 12px; font-size: 12px; font-weight: 600; 
        }
        .status-pending { background: #fff3cd; color: #856404; }
        .status-contacted { background: #d1ecf1; color: #0c5460; }
        .status-approved { background: #d4edda; color: #155724; }
        .status-rejected { background: #f8d7da; color: #721c24; }
        
        .modal { 
            display: none; position: fixed; z-index: 1000; left: 0; top: 0; 
            width: 100%; height: 100%; background: rgba(0,0,0,0.5); 
        }
        .modal-content { 
            background: white; margin: 5% auto; padding: 20px; border-radius: 8px; 
            width: 90%; max-width: 600px; max-height: 80vh; overflow-y: auto;
        }
        .modal-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .close { font-size: 24px; cursor: pointer; }
        
        .stats { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px; margin-bottom: 30px; }
        .stat-card { background: white; padding: 20px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); text-align: center; }
        .stat-number { font-size: 32px; font-weight: bold; color: #8a5cf6; }
        .stat-label { color: #666; margin-top: 5px; }
    </style>
</head>
<body>
    <div class="header">
        <div class="container">
            <h1>TechnoDome Franchise Admin Panel</h1>
            <p>Manage your franchise website content and applications</p>
        </div>
    </div>

    <div class="container">
        <div class="stats">
            <div class="stat-card">
                <div class="stat-number"><?php echo mysqli_num_rows($applications); ?></div>
                <div class="stat-label">Total Applications</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?php echo mysqli_num_rows($testimonials); ?></div>
                <div class="stat-label">Testimonials</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?php echo mysqli_num_rows($faqs); ?></div>
                <div class="stat-label">FAQ Items</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?php echo mysqli_num_rows($sections); ?></div>
                <div class="stat-label">Content Sections</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?php echo mysqli_num_rows($media_gallery); ?></div>
                <div class="stat-label">Media Items</div>
            </div>
        </div>

        <div class="tabs">
            <a href="applications.php" class="tab">Applications</a>
            <a href="sections.php" class="tab">Content Sections</a>
            <a href="faq.php" class="tab">FAQ Management</a>
            <a href="testimonials.php" class="tab">Testimonials</a>
            <a href="media.php" class="tab">Media Gallery</a>
        </div>
