    </div>

    <script>
        function showTab(tabName) {
            // Hide all tab contents
            document.querySelectorAll('.tab-content').forEach(tab => {
                tab.classList.remove('active');
            });
            
            // Remove active class from all tabs
            document.querySelectorAll('.tab').forEach(tab => {
                tab.classList.remove('active');
            });
            
            // Show selected tab content
            document.getElementById(tabName).classList.add('active');
            
            // Add active class to clicked tab
            event.target.classList.add('active');
        }

        function showModal(modalId) {
            document.getElementById(modalId).style.display = 'block';
        }

        function closeModal(modalId) {
            document.getElementById(modalId).style.display = 'none';
        }

        function addNewSection() {
            // Reset form for adding new section
            document.getElementById('section_action').value = 'add_section';
            document.getElementById('section_id').value = '';
            document.getElementById('section_name').value = '';
            document.getElementById('section_type').value = 'hero';
            document.getElementById('section_title').value = '';
            document.getElementById('section_content').value = '';
            document.getElementById('section_order').value = '1';
            document.getElementById('section_active').checked = true;
            document.getElementById('sectionSubmitBtn').textContent = 'Save Section';
            showModal('sectionModal');
        }

        function editSection(id) {
            // Fetch section data and populate the form
            fetch('', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: 'action=get_section&id=' + id
            })
            .then(response => response.json())
            .then(data => {
                console.log('Section data received:', data); // Debug log
                if (data.success) {
                    document.getElementById('section_action').value = 'update_section';
                    document.getElementById('section_id').value = data.section.id;
                    document.getElementById('section_name').value = data.section.section_name;
                    document.getElementById('section_type').value = data.section.section_type;
                    document.getElementById('section_title').value = data.section.title;
                    document.getElementById('section_content').value = data.section.content;
                    document.getElementById('section_order').value = data.section.order_index;
                    document.getElementById('section_active').checked = data.section.is_active == 1;
                    document.getElementById('sectionSubmitBtn').textContent = 'Update Section';
                    showModal('sectionModal');
                } else {
                    alert('Error: ' + (data.message || 'Unknown error'));
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Error loading section data');
            });
        }

        function addNewFaq() {
            // Reset form for adding new FAQ
            document.getElementById('faq_action').value = 'add_faq';
            document.getElementById('faq_id').value = '';
            document.getElementById('faq_question').value = '';
            document.getElementById('faq_answer').value = '';
            document.getElementById('faq_order').value = '1';
            document.getElementById('faq_active').checked = true;
            document.getElementById('faqSubmitBtn').textContent = 'Save FAQ';
            showModal('faqModal');
        }

        function editFaq(id) {
            // Fetch FAQ data and populate the form
            fetch('', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: 'action=get_faq&id=' + id
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById('faq_action').value = 'update_faq';
                    document.getElementById('faq_id').value = data.faq.id;
                    document.getElementById('faq_question').value = data.faq.question;
                    document.getElementById('faq_answer').value = data.faq.answer;
                    document.getElementById('faq_order').value = data.faq.order_index;
                    document.getElementById('faq_active').checked = data.faq.is_active == 1;
                    document.getElementById('faqSubmitBtn').textContent = 'Update FAQ';
                    showModal('faqModal');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Error loading FAQ data');
            });
        }

        function editTestimonial(id) {
            showModal('testimonialModal');
        }

        function editMedia(id) {
            showModal('mediaModal');
        }

        function deleteMedia(id) {
            if (confirm('Are you sure you want to delete this media item?')) {
                const form = document.createElement('form');
                form.method = 'POST';
                form.innerHTML = `
                    <input type="hidden" name="action" value="delete_media">
                    <input type="hidden" name="id" value="${id}">
                `;
                document.body.appendChild(form);
                form.submit();
            }
        }

        function deleteSection(id) {
            if (confirm('Are you sure you want to delete this section?')) {
                const form = document.createElement('form');
                form.method = 'POST';
                form.innerHTML = `
                    <input type="hidden" name="action" value="delete_section">
                    <input type="hidden" name="id" value="${id}">
                `;
                document.body.appendChild(form);
                form.submit();
            }
        }

        function deleteFaq(id) {
            if (confirm('Are you sure you want to delete this FAQ?')) {
                const form = document.createElement('form');
                form.method = 'POST';
                form.innerHTML = `
                    <input type="hidden" name="action" value="delete_faq">
                    <input type="hidden" name="id" value="${id}">
                `;
                document.body.appendChild(form);
                form.submit();
            }
        }

        function deleteTestimonial(id) {
            if (confirm('Are you sure you want to delete this testimonial?')) {
                const form = document.createElement('form');
                form.method = 'POST';
                form.innerHTML = `
                    <input type="hidden" name="action" value="delete_testimonial">
                    <input type="hidden" name="id" value="${id}">
                `;
                document.body.appendChild(form);
                form.submit();
            }
        }

        function toggleMediaFields() {
            const mediaType = document.getElementById('media_type').value;
            const imageField = document.getElementById('image_field');
            const videoField = document.getElementById('video_field');
            const youtubeIdField = document.getElementById('youtube_id_field');
            
            if (mediaType === 'image') {
                imageField.style.display = 'block';
                videoField.style.display = 'none';
                youtubeIdField.style.display = 'none';
            } else if (mediaType === 'video') {
                imageField.style.display = 'none';
                videoField.style.display = 'block';
                youtubeIdField.style.display = 'block';
            }
        }

        // Auto-extract YouTube ID from URL
        document.getElementById('media_video_url').addEventListener('input', function() {
            const url = this.value;
            const youtubeId = extractYouTubeId(url);
            if (youtubeId) {
                document.getElementById('media_youtube_id').value = youtubeId;
            }
        });
        
        document.querySelectorAll('.toggle-status').forEach(button => {
            button.addEventListener('click', function () {
                const id = this.getAttribute('data-id');
                const currentStatus = this.getAttribute('data-status');
                const newStatus = currentStatus == "1" ? 0 : 1;

                fetch("", {
                    method: "POST",
                    headers: { "Content-Type": "application/x-www-form-urlencoded" },
                    body: "action=toggle_section_status&id=" + id + "&status=" + newStatus
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        this.setAttribute('data-status', newStatus);
                        this.textContent = newStatus == 1 ? "Deactivate" : "Activate";
                        this.closest("tr").querySelector("td:nth-child(5)").textContent = newStatus == 1 ? "Active" : "Inactive";
                    }
                });
            });
        });

        function extractYouTubeId(url) {
            const regExp = /^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|&v=)([^#&?]*).*/;
            const match = url.match(regExp);
            return (match && match[2].length === 11) ? match[2] : null;
        }

        function viewApplication(id) {
            // This would show application details
            alert('View application details for ID: ' + id);
        }

        // Close modal when clicking outside
        window.onclick = function(event) {
            if (event.target.classList.contains('modal')) {
                event.target.style.display = 'none';
            }
        }
    </script>
</body>
</html>
