<?php
include 'includes/header.php';
?>

<!-- FAQ Tab -->
<div id="faq" class="tab-content active">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
        <h2>FAQ Management</h2>
        <button class="btn" onclick="addNewFaq()">Add New FAQ</button>
    </div>
    <table class="table">
        <thead>
            <tr>
                <th>Question</th>
                <th>Order</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($faq = mysqli_fetch_assoc($faqs)): ?>
            <tr>
                <td><?php echo htmlspecialchars(substr($faq['question'], 0, 50)) . '...'; ?></td>
                <td><?php echo $faq['order_index']; ?></td>
                <td><?php echo $faq['is_active'] ? 'Active' : 'Inactive'; ?></td>
                <td>
                    <button class="btn btn-sm" onclick="editFaq(<?php echo $faq['id']; ?>)">Edit</button>
                    <button class="btn btn-sm btn-danger" onclick="deleteFaq(<?php echo $faq['id']; ?>)">Delete</button>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>

<!-- FAQ Modal -->
<div id="faqModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h3>Add/Edit FAQ</h3>
            <span class="close" onclick="closeModal('faqModal')">&times;</span>
        </div>
        <form method="POST" id="faqForm">
            <input type="hidden" name="action" id="faq_action" value="add_faq">
            <input type="hidden" name="id" id="faq_id">
            <div class="form-group">
                <label>Question</label>
                <input type="text" name="question" id="faq_question" required>
            </div>
            <div class="form-group">
                <label>Answer</label>
                <textarea name="answer" id="faq_answer" rows="4" required></textarea>
            </div>
            <div class="form-group">
                <label>Order Index</label>
                <input type="number" name="order_index" id="faq_order" value="1">
            </div>
            <div class="form-group">
                <label>
                    <input type="checkbox" name="is_active" id="faq_active" checked> Active
                </label>
            </div>
            <button type="submit" class="btn" id="faqSubmitBtn">Save FAQ</button>
        </form>
    </div>
</div>

<?php include 'includes/footer.php'; ?>