<?php
require_once __DIR__ . "/../db.php";
require_once __DIR__ . "/../session.php";

requireAuth();

$current_business = getCurrentBusiness();
if (!$current_business) {
    header('Location: ' . BASE_URL . '/public/login.php');
    exit;
}

$business_id = $current_business['business_id'];

// =====================================================
// 1. DATA FETCHING (VIEW MODE LOGIC)
// =====================================================
$view_mode = false; 
$sale_data = [];
$sale_items_data = [];

if (isset($_GET['id'])) {
    $sale_id = $_GET['id'];
    $sale_data = one("SELECT s.*, it.type_name FROM sales s JOIN invoice_types it ON s.invoice_type_id = it.id WHERE s.id = ? AND s.business_id = ?", [$sale_id, $business_id]);

    if ($sale_data) {
        $view_mode = true; 
        $sale_items_data = all_rows("SELECT si.*, i.item_name FROM sale_items si JOIN new_items i ON si.item_id = i.id WHERE si.sale_id = ?", [$sale_id]);
    }
}

// =====================================================
// 2. SAVE LOGIC
// =====================================================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_sale']) && !$view_mode) {
    if (!isset($_POST['item_id']) || !is_array($_POST['item_id'])) {
        $_SESSION['error'] = "Please add at least one item.";
        header("Location: " . $_SERVER['REQUEST_URI']);
        exit;
    }

    $invoice_type_id = (int)($_POST['invoice_type'] ?? 0);
    $type_settings = one("SELECT tax_type FROM invoice_types WHERE id = ? AND business_id = ?", [$invoice_type_id, $business_id]);
    $is_inclusive = ($type_settings && $type_settings['tax_type'] === 'inclusive');
    
    // Inputs
    $party_id = $_POST['party'] ?? 0;
    $bill_no = $_POST['bill_no'] ?? '';
    $sale_date = $_POST['sale_date'] ?? date('Y-m-d');
    $due_date = $_POST['due_date'] ?? date('Y-m-d');
    $terms = $_POST['terms'] ?? 'Cash';
    $cash_tendered = (float)($_POST['cash_tendered'] ?? 0);
    
    // Decimal Inputs
    $dis_per_all = (float)($_POST['dis_per_all'] ?? 0);
    $overall_discount = (float)($_POST['overall_discount'] ?? 0);
    $delivery_charges = (float)($_POST['delivery_charges'] ?? 0);
    $freight_charges = (float)($_POST['freight_charges'] ?? 0);

    $items_id = $_POST['item_id'] ?? [];
    $batch = $_POST['batch_no'] ?? [];
    $qty = $_POST['qty'] ?? [];     
    $alt_qty = $_POST['alt_qty'] ?? []; 
    $free = $_POST['free_qty'] ?? [];
    $rate = $_POST['rate'] ?? [];     
    $dis_per = $_POST['dis_per'] ?? [];
    $tax_per = $_POST['tax_per'] ?? [];

    $subtotal = 0; $total_dis = 0; $total_tax = 0; $item_grand_total = 0;

    foreach ($items_id as $i => $id) {
        $q = (float)($qty[$i] ?? 0);
        $r = (float)($rate[$i] ?? 0);
        $d = (float)($dis_per[$i] ?? 0);
        $t = (float)($tax_per[$i] ?? 0);

        if ($is_inclusive) {
            $gross_inclusive = $q * $r; 
            $d_amt = $gross_inclusive * ($d / 100);
            $net_inclusive = $gross_inclusive - $d_amt;
            $taxable = $net_inclusive / (1 + ($t / 100));
            $t_amt = $net_inclusive - $taxable;
            $basic = $taxable;
        } else {
            $basic = $q * $r;
            $d_amt = $basic * ($d / 100);
            $taxable = $basic - $d_amt;
            $t_amt = $taxable * ($t / 100);
        }
        $net = $taxable + $t_amt;
        $subtotal += $basic;
        $total_dis += $d_amt;
        $total_tax += $t_amt;
        $item_grand_total += $net;
    }

    $final_grand_total = ($item_grand_total - $overall_discount) + $delivery_charges + $freight_charges;
    $change_amt = $cash_tendered - $final_grand_total;
    $half_tax = $total_tax / 2;

    query(
        "INSERT INTO sales 
        (business_id, party_id, bill_no, invoice_type_id, sale_date, due_date, payment_terms,
         subtotal, total_discount, total_tax, cgst, sgst, 
         discount_all, discount_all_per, delivery_charges, freight_charges, grand_total,
         cash_tendered, change_amount, created_at)
        VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())",
        [$business_id, $party_id, $bill_no, $invoice_type_id, $sale_date, $due_date, $terms, 
         $subtotal, $total_dis, $total_tax, $half_tax, $half_tax,
         $overall_discount, $dis_per_all, $delivery_charges, $freight_charges, $final_grand_total,
         $cash_tendered, $change_amt]
    );
    $sale_id = last_id();

    foreach ($items_id as $i => $id) {
        $q = (float)($qty[$i] ?? 0); $f = (float)($free[$i] ?? 0);
        $r = (float)($rate[$i] ?? 0); $d = (float)($dis_per[$i] ?? 0);
        $t = (float)($tax_per[$i] ?? 0); $b = ($batch[$i] ?? '');
        $a_qty = ($alt_qty[$i] ?? 0);

        if ($is_inclusive) {
             $gross_inclusive = $q * $r; $d_amt = $gross_inclusive * ($d / 100);
             $net_inclusive = $gross_inclusive - $d_amt;
             $taxable = $net_inclusive / (1 + ($t / 100));
             $t_amt = $net_inclusive - $taxable;
             $net = $net_inclusive; $basic_db = $taxable; 
        } else {
             $basic_db = $q * $r; $d_amt = $basic_db * ($d / 100);
             $taxable = $basic_db - $d_amt; $t_amt = $taxable * ($t / 100);
             $net = $taxable + $t_amt;
        }

        query(
            "INSERT INTO sale_items
            (business_id, sale_id, item_id, batch_no, qty, alt_qty, free_qty, rate, amount,
             discount_per, discount_amt, tax_per, tax_amt, net_value)
            VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)",
            [$business_id, $sale_id, $id, $b, $q, $a_qty, $f, $r, $basic_db, $d, $d_amt, $t, $t_amt, $net]
        );
        query("UPDATE new_items SET opening_qty_kg = opening_qty_kg - ? WHERE id = ? AND business_id = ?", [$q + $f, $id, $business_id]);
    }

    $_SESSION['success'] = "Sale saved successfully!";
    $_SESSION['last_sale_id'] = $sale_id;
    echo "<script>window.location.href='" . BASE_URL . "/public/index.php?r=sale&id={$sale_id}';</script>";
    exit;
}

// =====================================================
// 3. LOAD DATA
// =====================================================
$parties = all_rows("SELECT id, name FROM accounts WHERE business_id = ? ORDER BY name", [$business_id]);
$items = all_rows("SELECT id, item_name, primary_unit, alternate_unit, sale_price, purchase_price, mrp, opening_qty_kg, conversion_factor, tax_slab FROM new_items WHERE business_id = ? ORDER BY item_name", [$business_id]);
$invoice_types = all_rows("SELECT id, type_name, tax_type FROM invoice_types WHERE business_id = ?", [$business_id]);
$disabled = $view_mode ? 'disabled' : '';
?>

<!DOCTYPE html>
<html>
<head>
    <title>Sale View</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body { background-image: url("<?= BASE_URL ?>/public/grocery.png"); background-size: cover; background-attachment: fixed; background-position: center; background-color: #f4f6f9; font-size: 14px; }
        .card { background: rgba(255, 255, 255, 0.95); border-radius: 8px; padding: 15px; border:none; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        .form-control, .form-select { border-radius: 4px; font-size: 13px; padding: 5px 8px; }
        .table th { background: #00bcd4; color: white; font-weight: 500; font-size: 13px; white-space: nowrap; } 
        label { font-weight: 600; font-size: 12px; margin-bottom: 2px; }
        .table td { vertical-align: middle; padding: 5px; background: rgba(255,255,255,0.8); }
        .bg-light-blue { background-color: #e0f7fa !important; }
        .charges-section { border-bottom: 1px solid #ffffff40; padding-bottom: 10px; margin-bottom: 10px; }
        .form-control:disabled, .form-select:disabled { background-color: #e9ecef; opacity: 1; color: #333; font-weight: 500; border: 1px solid #ced4da; }
        .footer-totals input { font-weight: bold; text-align: right; }
        .form-select { background-position: right 0.75rem center; background-size: 16px 12px; padding-right: 2.5rem; text-overflow: ellipsis; }
        .invoice-type-select { min-width: 140px; border-top-left-radius: 0; border-bottom-left-radius: 0; }
        @media (min-width: 768px) {
            .col-md-w-6 { width: 6% !important; flex: 0 0 6% !important; max-width: 6% !important; }
            .col-md-w-7 { width: 7% !important; flex: 0 0 7% !important; max-width: 7% !important; }
            .col-md-w-13 { width: 13% !important; flex: 0 0 13% !important; max-width: 13% !important; }
        }
        @media (max-width: 767px) {
            .card { padding: 10px; } .form-control, .form-select { font-size: 14px; padding: 6px; } #entryRow > div { margin-bottom: 8px; } .btn-success { width: 100%; margin-top: 5px; } .table-responsive { border: 1px solid #ddd; }
        }
    </style>
</head>
<body>

<div class="container-fluid mt-3">
    <?php if(isset($_SESSION['success'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <strong>Success!</strong> <?= $_SESSION['success']; ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    <?php unset($_SESSION['success']); ?>
    <?php endif; ?>

    <form method="post" id="saleForm">
        <div class="d-flex flex-wrap justify-content-between align-items-center mb-3 gap-2">
            <h4 class="text-primary m-0"><?= $view_mode ? 'VIEW SALE #' . ($sale_data['id'] ?? '') : 'SALE ENTRY' ?></h4>
            <div class="input-group" style="width: auto; min-width: 250px;">
                <span class="input-group-text bg-white text-primary fw-bold">Invoice Type</span>
                <select name="invoice_type" id="invoiceTypeSelect" class="form-select text-primary fw-bold invoice-type-select" <?= $disabled ?>>
                    <?php
                    $sel_type = $view_mode ? ($sale_data['invoice_type_id'] ?? 0) : 0;
                    if (empty($invoice_types)) { echo '<option value="0">GST Invoice</option>'; } 
                    else { foreach ($invoice_types as $type) { $sel = ($sel_type == $type['id']) ? 'selected' : ''; echo "<option value='{$type['id']}' data-tax-type='{$type['tax_type']}' $sel>{$type['type_name']}</option>"; } }
                    ?>
                </select>
            </div>
        </div>

        <div class="card mb-3">
            <div class="row g-2">
                <div class="col-12 col-md-3">
                    <div class="d-flex justify-content-between align-items-center"><label>Party Name</label><a href="<?= BASE_URL ?>/public/index.php?r=create_account" target="_blank" style="font-size: 11px; text-decoration: none; color: rgba(var(--bs-primary-rgb));">+ Add New Party</a></div>
                    <select name="party" class="form-select" required <?= $disabled ?>><option value="">Select Party</option><?php foreach ($parties as $p): ?><option value="<?= $p['id'] ?>" <?= ($view_mode && $sale_data['party_id'] == $p['id']) ? 'selected' : '' ?>><?= $p['name'] ?></option><?php endforeach; ?></select>
                </div>
                <div class="col-6 col-md-2"><label>Sale Date</label><input type="date" name="sale_date" class="form-control" value="<?= $view_mode ? $sale_data['sale_date'] : date('Y-m-d') ?>" <?= $disabled ?>></div>
                <div class="col-6 col-md-2"><label>Terms</label><select name="terms" class="form-select" <?= $disabled ?>><?php $t = $view_mode ? ($sale_data['payment_terms']??'') : 'Cash'; ?><option value="Credit" <?= $t=='Credit'?'selected':'' ?>>Credit</option><option value="Cash" <?= $t=='Cash'?'selected':'' ?>>Cash</option></select></div>
                <div class="col-6 col-md-2"><label>No. (Bill #)</label><input type="text" name="bill_no" class="form-control" placeholder="Auto" value="<?= $view_mode ? ($sale_data['bill_no']??'') : '' ?>" <?= $disabled ?>></div>
                <div class="col-6 col-md-3"><label>Due Date</label><input type="date" name="due_date" class="form-control" value="<?= $view_mode ? ($sale_data['due_date']??date('Y-m-d')) : date('Y-m-d') ?>" <?= $disabled ?>></div>
            </div>
        </div>

        <?php if(!$view_mode): ?>
        <div class="card mb-3 bg-light-blue">
             <div class="row g-1 align-items-end" id="entryRow">
                 <div class="col-12 col-md-2">
                    <label>Item Name</label>
                    <select class="form-select itemSel">
                        <option value="">Select Item</option>
                        <?php foreach ($items as $i): ?>
                        <option value="<?= $i['id'] ?>" data-rate="<?= $i['sale_price'] ?>" data-purchase="<?= $i['purchase_price'] ?>" data-mrp="<?= $i['mrp'] ?>" data-tax="<?= $i['tax_slab'] ?>" data-unit="<?= $i['primary_unit'] ?>" data-alt-unit="<?= $i['alternate_unit'] ?? '' ?>" data-factor="<?= $i['conversion_factor'] ?? 1 ?>" data-stock="<?= $i['opening_qty_kg'] ?>"><?= $i['item_name'] ?></option>
                        <?php endforeach; ?>
                    </select>
                 </div>
                 <div class="col-4 col-md-1"><label class="text-danger">Stock</label><input type="text" class="form-control stock-display" readonly></div>
                 <div class="col-4 col-md-w-7"><label>Batch</label><input type="text" class="form-control batch" placeholder="Batch"></div>
                 <div class="col-4 col-md-w-7"><label id="lblQty">Qty</label><input type="number" class="form-control qty" placeholder="Qty"></div>
                 <div class="col-4 col-md-w-7"><label id="lblAlt">Alt</label><input type="number" class="form-control alt_qty" placeholder="Alt"></div>
                 <div class="col-4 col-md-w-6"><label>Free</label><input type="number" class="form-control free" value="0"></div>
                 <div class="col-12 col-md-w-13">
                     <label>Price & Unit</label>
                     <select class="form-select price-sel" style="width: 100%;"></select>
                     <input type="hidden" class="rate">
                 </div>
                 <div class="col-4 col-md-1"><label>Basic</label><input type="text" class="form-control basic_amt" readonly></div>
                 <div class="col-4 col-md-w-7"><label>Dis%</label><input type="number" class="form-control dis_per" value="0"></div>
                 <div class="col-4 col-md-w-7"><label>Tax%</label><input type="number" class="form-control tax_per" readonly></div>
                 <div class="col-12 col-md-1"><label>Net</label><input type="text" class="form-control net_value" readonly><input type="hidden" class="tax_amt_hidden"></div>
             </div>
            <div class="col-12 mt-3 text-end"><button type="button" class="btn btn-success px-4" id="addItem">Add Item +</button></div>
        </div>
        <?php endif; ?>

        <div class="card mb-3 p-0" style="min-height: 200px;">
            <div class="table-responsive">
                <table class="table table-bordered mb-0 text-nowrap">
                    <thead>
                        <tr>
                            <th>Item Name</th><th>Qty</th><th>Alt</th><th>Price</th><th>Basic</th><th>Dis %</th><th>Tax</th><th>Net Value</th>
                            <?php if(!$view_mode): ?><th>Act</th><?php endif; ?>
                        </tr>
                    </thead>
                    <tbody id="addedItems">
                        <?php if(!empty($sale_items_data)): ?>
                            <?php foreach($sale_items_data as $item): ?>
                                <tr>
                                    <td><?= htmlspecialchars($item['item_name']) ?> <br><small class="text-muted"><?= $item['batch_no'] ?></small></td>
                                    <td><?= $item['qty'] ?></td>
                                    <td><?= $item['alt_qty'] ?></td>
                                    <td><?= $item['rate'] ?></td>
                                    <td><?= number_format($item['amount'], 2) ?></td>
                                    <td><?= $item['discount_per'] ?>%</td>
                                    <td><?= $item['tax_per'] ?>% <br><small class="text-muted">(<?= $item['tax_amt'] ?>)</small></td>
                                    <td class="row-net"><?= number_format($item['net_value'], 2) ?></td>
                                    <?php if(!$view_mode): ?><td><button type="button" class="btn btn-danger btn-sm">X</button></td><?php endif; ?>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="card bg-secondary text-white p-3">
            <div class="row g-2 align-items-center charges-section">
                <div class="col-12 col-md-3">
                    <label>Total Item Value</label>
                    <input type="text" class="form-control" id="itemsSubtotal" readonly value="<?= $view_mode ? $sale_data['subtotal'] : '' ?>">
                </div>
                <div class="col-6 col-md-2">
                    <label>Overall Disc (%)</label>
                    <input type="number" step="0.01" class="form-control" id="disPerAll" name="dis_per_all" value="<?= $view_mode ? ($sale_data['discount_all_per']??'') : '' ?>" <?= $disabled ?> placeholder="%">
                </div>
                <div class="col-6 col-md-2">
                    <label>Less: Discount</label>
                    <input type="number" step="0.01" class="form-control text-danger fw-bold" id="disAmtAll" name="overall_discount" value="<?= $view_mode ? $sale_data['discount_all'] : '' ?>" <?= $disabled ?>>
                </div>
                <div class="col-6 col-md-2">
                    <label>Add: Delivery</label>
                    <input type="number" step="0.01" class="form-control text-success fw-bold" id="deliveryCharges" name="delivery_charges" value="<?= $view_mode ? $sale_data['delivery_charges'] : '' ?>" <?= $disabled ?>>
                </div>
                <div class="col-6 col-md-3">
                    <label>Add: Freight</label>
                    <input type="number" step="0.01" class="form-control text-success fw-bold" id="freightCharges" name="freight_charges" value="<?= $view_mode ? $sale_data['freight_charges'] : '' ?>" <?= $disabled ?>>
                </div>
            </div>

            <div class="row g-2 align-items-center mt-2">
                <div class="col-md-6 d-none d-md-block"></div> 
                <div class="col-12 col-md-2 text-end">
                    <label>NET GRAND TOTAL</label>
                    <input type="text" class="form-control fs-5" id="grandTotal" readonly style="background:#ffc107; color:#000;" value="<?= $view_mode ? number_format($sale_data['grand_total'], 2) : '' ?>">
                </div>
                <div class="col-6 col-md-2 text-end">
                    <label>Cash Tendered</label>
                    <input type="number" step="0.01" name="cash_tendered" class="form-control" id="cashTendered" value="<?= $view_mode ? $sale_data['cash_tendered'] : '0' ?>" <?= $disabled ?>>
                </div>
                <div class="col-6 col-md-2 text-end">
                    <label>Change</label>
                    <input type="text" class="form-control" id="changeAmt" readonly value="<?= $view_mode ? $sale_data['change_amount'] : '' ?>">
                </div>
            </div>

            <div class="text-end mt-4">
                <?php if(!$view_mode): ?>
                    <button type="submit" name="save_sale" class="btn btn-warning fw-bold px-5 w-md-auto">SAVE SALE</button>
                <?php else: ?>
                    <a href="index.php?r=invoice&id=<?= $sale_id ?>" target="_blank" class="btn btn-dark fw-bold ms-2">GENERATE INVOICE</a>
                    <a href="index.php?r=sale" class="btn btn-primary fw-bold ms-2">NEW SALE</a>
                    <a href="index.php?r=reports/cash_credit" class="btn btn-light fw-bold">Back</a>
                    
                <?php endif; ?>
            </div>
        </div>

    </form>
</div>

<?php if(!$view_mode): ?>
<script>
let currentFactor=1;function calculateRow(){let e=document.getElementById("entryRow");if(!e)return;let t=parseFloat(e.querySelector(".qty").value)||0,l=parseFloat(e.querySelector(".rate").value)||0,a=parseFloat(e.querySelector(".dis_per").value)||0,r=parseFloat(e.querySelector(".tax_per").value)||0,n=document.getElementById("invoiceTypeSelect"),o=n.options[n.selectedIndex].dataset.taxType,c=0,u=0,i=0;if("inclusive"===o){let d=t*l,s=d*(a/100),p=d-s,y=p/(1+r/100);u=p-y,c=y,i=p,e.querySelector(".basic_amt").value=y.toFixed(2)}else{c=t*l;let m=c*(a/100),v=c-m;u=v*(r/100),i=v+u,e.querySelector(".basic_amt").value=c.toFixed(2)}e.querySelector(".tax_amt_hidden").value=u.toFixed(2),e.querySelector(".net_value").value=i.toFixed(2)}document.getElementById("invoiceTypeSelect").addEventListener("change",function(){calculateRow()}),document.querySelector(".itemSel").addEventListener("change",function(){if(""===this.value)return;let e=this.options[this.selectedIndex],t=document.getElementById("entryRow"),l=parseFloat(e.dataset.rate)||0,a=parseFloat(e.dataset.purchase)||0,r=parseFloat(e.dataset.mrp)||0,n=e.dataset.unit||"Qty",o=e.dataset.altUnit||"",c=parseFloat(e.dataset.factor)||1,u=e.dataset.stock||0;document.getElementById("lblQty").innerText="Qty ("+n+")",t.querySelector(".qty").placeholder=n,o&&c>1?(document.getElementById("lblAlt").innerText="Alt ("+o+")",t.querySelector(".alt_qty").placeholder=o,t.querySelector(".alt_qty").disabled=!1):(document.getElementById("lblAlt").innerText="Alt",t.querySelector(".alt_qty").placeholder="-",t.querySelector(".alt_qty").disabled=!0),currentFactor=c,t.querySelector(".stock-display").value=u,t.querySelector(".tax_per").value=parseFloat(e.dataset.tax)||0;let i=t.querySelector(".price-sel");i.innerHTML="",i.add(new Option(`Sale (${l}/${n})`,l)),o&&c>1&&i.add(new Option(`Sale (${(l*c).toFixed(2)}/${o})`,l)),["gms","g","ml"].includes(n.toLowerCase())&&i.add(new Option(`Sale (${(100*l).toFixed(2)}/100${n})`,l)),r>0&&i.add(new Option(`MRP (${r}/${n})`,r)),a>0&&i.add(new Option(`Purchase (${a}/${n})`,a)),t.querySelector(".rate").value=l,calculateRow()}),document.querySelector(".price-sel").addEventListener("change",function(){document.querySelector(".rate").value=this.value,calculateRow()}),document.querySelector(".alt_qty").addEventListener("input",function(){let e=parseFloat(this.value)||0;document.querySelector(".qty").value=e*currentFactor,calculateRow()});let inputs=document.querySelectorAll("#entryRow input");inputs.forEach(e=>e.addEventListener("input",calculateRow)),document.getElementById("addItem").addEventListener("click",function(){let e=document.getElementById("entryRow"),t=e.querySelector(".itemSel");if(""===t.value)return void alert("Select Item");let l=t.value,a=t.options[t.selectedIndex].text,r=e.querySelector(".batch").value,n=e.querySelector(".qty").value,o=e.querySelector(".alt_qty").value,c=e.querySelector(".free").value,u=e.querySelector(".rate").value,i=e.querySelector(".dis_per").value,d=e.querySelector(".tax_per").value,s=e.querySelector(".tax_amt_hidden").value,p=e.querySelector(".net_value").value,y=e.querySelector(".basic_amt").value,m=`\n        <tr>\n            <td>\n                ${a} <br><small class="text-muted">${r}</small>\n                <input type="hidden" name="item_id[]" value="${l}"> \n                <input type="hidden" name="batch_no[]" value="${r}">\n            </td>\n            <td>${n} <input type="hidden" name="qty[]" value="${n}"></td>\n            <td>${o} <input type="hidden" name="alt_qty[]" value="${o}"></td>\n            <td>${u} <input type="hidden" name="rate[]" value="${u}"></td>\n            <td>${y}</td>\n            <td>${i}% <input type="hidden" name="dis_per[]" value="${i}"></td>\n            <td>\n                ${d}% <br><small class="text-muted">(${s})</small>\n                <input type="hidden" name="tax_per[]" value="${d}">\n                <input type="hidden" name="free_qty[]" value="${c}">\n            </td>\n            <td class="row-net">${p}</td>\n            <td><button type="button" class="btn btn-danger btn-sm remove-btn">X</button></td>\n        </tr>\n    `;document.getElementById("addedItems").innerHTML+=m,updateGrandTotal(),t.value="",e.querySelector(".qty").value="",e.querySelector(".alt_qty").value="",e.querySelector(".batch").value="",e.querySelector(".free").value="0",e.querySelector(".rate").value="",e.querySelector(".dis_per").value="0",e.querySelector(".tax_per").value="",e.querySelector(".basic_amt").value="",e.querySelector(".net_value").value="",e.querySelector(".price-sel").innerHTML=""}),document.addEventListener("click",function(e){e.target&&e.target.classList.contains("remove-btn")&&(e.target.closest("tr").remove(),updateGrandTotal())});function updateGrandTotal(){let e=0;document.querySelectorAll(".row-net").forEach(t=>{e+=parseFloat(t.innerText)}),document.getElementById("itemsSubtotal").value=e.toFixed(2);let t=parseFloat(document.getElementById("disPerAll").value)||0,l=parseFloat(document.getElementById("disAmtAll").value)||0,a=parseFloat(document.getElementById("deliveryCharges").value)||0,r=parseFloat(document.getElementById("freightCharges").value)||0,n=e-l+a+r;document.getElementById("grandTotal").value=n.toFixed(2),calcChange()}document.getElementById("disPerAll").addEventListener("input",function(){let e=parseFloat(document.getElementById("itemsSubtotal").value)||0,t=parseFloat(this.value)||0,l=e*(t/100);document.getElementById("disAmtAll").value=l.toFixed(2),updateGrandTotal()}),document.getElementById("disAmtAll").addEventListener("input",function(){document.getElementById("disPerAll").value="",updateGrandTotal()}),document.getElementById("deliveryCharges").addEventListener("input",updateGrandTotal),document.getElementById("freightCharges").addEventListener("input",updateGrandTotal),document.getElementById("cashTendered").addEventListener("input",calcChange);function calcChange(){let e=parseFloat(document.getElementById("grandTotal").value)||0,t=parseFloat(document.getElementById("cashTendered").value)||0;document.getElementById("changeAmt").value=(t-e).toFixed(2)}
</script>
<?php endif; ?>

</body>
</html>