<?php
require_once __DIR__ . "/../db.php";
require_once __DIR__ . "/../session.php";

requireAuth();

$current_business = getCurrentBusiness();
if (!$current_business) {
    header('Location: ' . BASE_URL . '/public/login.php');
    exit;
}

$business_id = $current_business['business_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_payment'])) {
    $party_id     = $_POST['party_id'];
    $amount       = $_POST['amount'];
    $payment_date = $_POST['payment_date'];
    $payment_mode = $_POST['payment_mode'];
    $payment_type = $_POST['payment_type']; // RECEIPT or PAYMENT
    $remarks      = $_POST['remarks'];

    query("INSERT INTO payments (business_id, party_id, amount, payment_date, payment_mode, payment_type, remarks)
           VALUES (?,?,?,?,?,?,?)",
           [$business_id, $party_id, $amount, $payment_date, $payment_mode, $payment_type, $remarks]);

    echo "<script>alert('Payment Recorded Successfully!'); window.location.href=window.location.href;</script>";
}

$parties = all_rows("SELECT id, name, group_name FROM accounts WHERE business_id = ? ORDER BY name", [$business_id]);
$recent_payments = all_rows("
    SELECT p.*, a.name as party_name 
    FROM payments p 
    JOIN accounts a ON p.party_id = a.id 
    WHERE p.business_id = ? 
    ORDER BY p.payment_date DESC, p.id DESC LIMIT 50", [$business_id]);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Payment Entry</title>
    <style>
        body { background: #f4f6f9; font-size: 14px; }
        body { 
            /* Merged background styles so image works */
            background-image: url("<?= BASE_URL ?>/public/grocery.png");
            background-size: cover;
            background-repeat: no-repeat;
            background-attachment: fixed;
            background-position: center;
            background-color: #f4f6f9; /* Fallback */
            font-size: 14px;
        }
        .card { border-radius: 8px; padding: 15px; border:none; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        .form-control, .form-select { border-radius: 4px; font-size: 13px; padding: 5px 8px; }
        .table th { background: #6c757d; color: white; font-weight: 500; font-size: 13px; }
        label { font-weight: 600; font-size: 12px; margin-bottom: 2px; }
        .type-receipt { color: green; font-weight: bold; }
        .type-payment { color: red; font-weight: bold; }
    </style>
</head>
<body>

<div class="container-fluid mt-3">
    <h4 class="mb-3">PAYMENT / RECEIPT ENTRY</h4>

    <div class="row">
        <div class="col-md-4">
            <div class="card">
                <h5>Add New Entry</h5>
                <form method="post">
                    <div class="mb-2">
                        <label>Date</label>
                        <input type="date" name="payment_date" class="form-control" value="<?= date('Y-m-d') ?>" required>
                    </div>
                    <div class="mb-2">
                        <label>Party</label>
                        <select name="party_id" class="form-select" required>
                            <option value="">Select Party</option>
                            <?php foreach ($parties as $p): ?>
                                <option value="<?= $p['id'] ?>"><?= $p['name'] ?> (<?= $p['group_name'] ?>)</option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-2">
                        <label>Type</label>
                        <select name="payment_type" class="form-select" required>
                            <option value="RECEIPT">RECEIPT (Received From Customer)</option>
                            <option value="PAYMENT">PAYMENT (Paid To Supplier)</option>
                        </select>
                    </div>
                    <div class="mb-2">
                        <label>Amount</label>
                        <input type="number" step="0.01" name="amount" class="form-control" required>
                    </div>
                    <div class="mb-2">
                        <label>Mode</label>
                        <select name="payment_mode" class="form-select">
                            <option value="Cash">Cash</option>
                            <option value="Bank">Bank / UPI</option>
                            <option value="Cheque">Cheque</option>
                        </select>
                    </div>
                    <div class="mb-2">
                        <label>Remarks</label>
                        <textarea name="remarks" class="form-control" rows="2"></textarea>
                    </div>
                    <button type="submit" name="save_payment" class="btn btn-primary w-100 mt-2">Save Entry</button>
                </form>
            </div>
        </div>
        <div class="col-md-8">
            <div class="card p-0">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Recent Transactions</h5>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Party</th>
                                <th>Type</th>
                                <th>Mode</th>
                                <th class="text-end">Amount</th>
                                <th>Remarks</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($recent_payments as $rp): ?>
                            <tr>
                                <td><?= date('d-m-Y', strtotime($rp['payment_date'])) ?></td>
                                <td><?= e($rp['party_name']) ?></td>
                                <td class="<?= $rp['payment_type'] == 'RECEIPT' ? 'type-receipt' : 'type-payment' ?>">
                                    <?= $rp['payment_type'] ?>
                                </td>
                                <td><?= e($rp['payment_mode']) ?></td>
                                <td class="text-end">₹ <?= number_format($rp['amount'], 2) ?></td>
                                <td><small class="text-muted"><?= e($rp['remarks']) ?></small></td>
                            </tr>
                            <?php endforeach; ?>
                            <?php if (empty($recent_payments)): ?>
                            <tr><td colspan="6" class="text-center py-3 text-muted">No transactions found</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

</body>
</html>
