<div class="card">
    <div class="card-header bg-primary text-white">
        <h5 class="mb-0">New Order</h5>
    </div>
    <div class="card-body">
        <form method="POST" action="<?= BASE_URL ?>/public/index.php?r=orders/new">
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Customer Name</label>
                    <input type="text" name="customer_name" class="form-control" required placeholder="Enter customer name">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Customer Mobile</label>
                    <input type="text" name="customer_mobile" class="form-control" required placeholder="Enter mobile number">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Order Type</label>
                    <select name="order_type" class="form-select" id="orderType">
                        <option value="table">Table</option>
                        <option value="takeaway">Takeaway</option>
                    </select>
                </div>
                <div class="col-md-6" id="tableNoDiv">
                    <label class="form-label">Table No.</label>
                    <input type="text" name="table_no" class="form-control" placeholder="Enter table number">
                </div>
            </div>
            <div class="mt-4">
                <button type="submit" class="btn btn-success">Start Order</button>
                <a href="<?= BASE_URL ?>/public/index.php?r=dashboard" class="btn btn-outline-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>

<script>
document.getElementById('orderType').addEventListener('change', function() {
    const tableDiv = document.getElementById('tableNoDiv');
    if (this.value === 'takeaway') {
        tableDiv.style.display = 'none';
        tableDiv.querySelector('input').removeAttribute('required');
    } else {
        tableDiv.style.display = 'block';
        tableDiv.querySelector('input').setAttribute('required', 'required');
    }
});
</script>
