<?php

require_once __DIR__ . '/../../db.php';
require_once __DIR__ . '/../../helpers.php';
require_once __DIR__ . '/../../session.php';

// Require authentication for all views
requireAuth();

// Get current business settings
$current_business = getCurrentBusiness();
if (!$current_business) {
    header('Location: ' . BASE_URL . '/public/login.php');
    exit;
}

$settings = one('SELECT * FROM settings WHERE id=?', [$current_business['business_id']]);
if (!$settings) {
    // Fallback to default settings if business settings not found
    $settings = one('SELECT * FROM settings WHERE id=1');
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?= e($settings['business_name'] ?? 'Billing') ?></title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
<style>
body {
  padding-top: 70px;
  background: #f6f7fb;
  font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto;
}
.container{
    background: rgba(255, 255, 255, 0.88);
    border-radius: 16px;
    padding: 1rem;
    box-shadow: 0 10px 30px rgba(0, 0, 0, .15);
    backdrop-filter: blur(2px);
  }
.custom-navbar {
  background: linear-gradient(135deg, #4847ea, #1b5ba3);
  box-shadow: 0 6px 20px rgba(0,0,0,0.15);
}

.navbar-brand {
  font-weight: 700;
}

.navbar-nav .nav-link {
  font-weight: 500;
  padding: 10px 14px;
  border-radius: 10px;
}

.navbar-nav .nav-link:hover {
  background: rgba(255,255,255,0.18);
}

.navbar-toggler {
  border: none;
  background: rgba(255,255,255,0.2);
}

.navbar-toggler:focus {
  box-shadow: none;
}

/* ✅ SAFE animation */
@media (max-width: 991px) {
  .navbar-collapse.show {
    animation: slideDown .25s ease-out;
  }

  @keyframes slideDown {
    from {
      opacity: 0;
      transform: translateY(-8px);
    }
    to {
      opacity: 1;
      transform: translateY(0);
    }
  }
}
</style>

</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark fixed-top custom-navbar">


  <a class="navbar-brand d-flex align-items-center" href="<?= BASE_URL ?>/public/?r=dashboard">
      <?php 
$logo = (!empty($settings['logo'])) 
        ? BASE_URL . "/src/api/uploads/" . $settings['logo'] 
        : BASE_URL . "/public/logo.jpg"; // fallback if no image
?>
    <img src="<?= $logo ?>"
         alt="Logo"
         style="height:30px; width:30px; margin-right:8px; border-radius:50%;">
    <?= e($settings['business_name'] ?? 'Billing') ?>
  </a>

  <button class="navbar-toggler" type="button"
          data-bs-toggle="collapse"
          data-bs-target="#navbarMenu"
          aria-controls="navbarMenu"
          aria-expanded="false"
          aria-label="Toggle navigation">
    <span class="navbar-toggler-icon"></span>
  </button>

  <!-- ONLY ONE collapse -->
  <div class="collapse navbar-collapse" id="navbarMenu">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>/public/index.php?r=items">Items</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>/public/index.php?r=add_items">New Items</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>/public/index.php?r=create_account">Accounts</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>/public/index.php?r=purchase">Purchases</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>/public/index.php?r=sale">Sale Entry</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>/public/index.php?r=payments">Payments</a></li>
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" id="reportsDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            Reports
          </a>
          <ul class="dropdown-menu" aria-labelledby="reportsDropdown">
            <li><a class="dropdown-item" href="<?= BASE_URL ?>/public/index.php?r=reports/stock">Stock Report</a></li>
            <li><a class="dropdown-item" href="<?= BASE_URL ?>/public/index.php?r=reports/cash_credit">Cash/Credit Report</a></li>
            <li><a class="dropdown-item" href="<?= BASE_URL ?>/public/index.php?r=reports/party_balance">Party Balances</a></li>
            <li><hr class="dropdown-divider"></li>
            <li><a class="dropdown-item" href="<?= BASE_URL ?>/public/index.php?r=reports">Order Reports</a></li>
          </ul>
        </li>


      </ul>
      <ul class="navbar-nav">
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            <?= e($current_business['business_name']) ?>
          </a>
          <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
            <li><a class="dropdown-item" href="<?= BASE_URL ?>/public/index.php?r=settings">Settings</a></li>
            <li><hr class="dropdown-divider"></li>
            <li><a class="dropdown-item" href="<?= BASE_URL ?>/public/logout.php">Logout</a></li>
          </ul>
        </li>
      </ul>
    </div>
</nav>

<div class="container">
  
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.2/js/bootstrap.bundle.min.js"
        integrity="sha512-BOs8W4zY6g8x9+Yj3BPjVAk0nnk3uKxR271GGBqBPdZiZsaAJ+lZeX7IuAvV38eRcVQQP4SRr2dJYdZLxE+nig=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
document.addEventListener("DOMContentLoaded", function () {
  const menu = document.getElementById("navbarMenu");
  if (!menu) return;

  const collapse = new bootstrap.Collapse(menu, { toggle: false });

  document.querySelectorAll(
    "#navbarMenu .nav-link:not(.dropdown-toggle), #navbarMenu .dropdown-item"
  ).forEach(link => {
    link.addEventListener("click", () => {
      if (window.innerWidth < 992) {
        collapse.hide();
      }
    });
  });
});
</script>


</body>
</html>

