<?php
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../session.php';

// --- SECURITY CHECK ---
requireAuth(); // Force login
$current_business = getCurrentBusiness();
if (!$current_business) {
    die("Access Denied: No business selected.");
}
// ----------------------

// Get sale ID
$sale_id = $_GET['id'] ?? 0;
if (!$sale_id) { die('Sale ID is required'); }

// Fetch sale data
$sale = row("SELECT s.*, acc.name as customer_name, acc.mobile as customer_phone 
            FROM sales s 
            LEFT JOIN accounts acc ON s.party_id = acc.id 
            WHERE s.id = ? AND s.business_id = ?", 
            [$sale_id, $current_business['business_id']]);

if (!$sale) { die('Sale not found or Access Denied'); }

// Fetch settings and items
$store = one("SELECT business_name as name, address, phone, gstin, gst_rate FROM settings WHERE id = ?", [$sale['business_id']]);

// Fetch Items
$items = all_rows("SELECT si.item_id, ni.item_name as name, si.qty, si.rate as price, si.amount as basic, si.net_value 
                 FROM sale_items si 
                 LEFT JOIN new_items ni ON si.item_id = ni.id 
                 WHERE si.sale_id = ?", [$sale_id]);

// Prepare Invoice Data
$invoice = [
    'invoice_no'   => $sale['bill_no'] ?: ('INV-' . $sale['id']),
    'date'         => date('d M Y', strtotime($sale['sale_date'])),
    'customer'     => $sale['customer_name'] ?: 'Walk-in Customer',
    'phone'        => $sale['customer_phone'] ?: 'N/A',
    'payment_mode' => $sale['payment_terms'] ?: 'Cash'
];

$gst_percent = $store['gst_rate'] ?? 5;

// --- VARIABLES ---
$subtotal = $sale['subtotal'] ?? 0;
$item_discount = $sale['total_discount'] ?? 0;
$overall_discount = $sale['discount_all'] ?? 0;
$delivery = $sale['delivery_charges'] ?? 0;
$freight = $sale['freight_charges'] ?? 0;
$cgst = $sale['cgst'] ?? 0;
$sgst = $sale['sgst'] ?? 0;
$grand_total = $sale['grand_total'] ?? 0;
?>

<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0"> <title>Invoice <?= $invoice['invoice_no'] ?></title>
<style>
    body { font-family: "Segoe UI", Arial, sans-serif; background: #f2f4f7; padding: 20px; }
    .invoice { max-width: 850px; margin: auto; background: #fff; padding: 30px; border-radius: 6px; box-shadow: 0 0 10px rgba(0,0,0,.08); }
    .header { display: flex; justify-content: space-between; border-bottom: 2px solid #222; padding-bottom: 15px; margin-bottom: 20px; }
    .store h2 { margin: 0; font-size: 22px; }
    .store small { color: #555; line-height: 1.6; }
    .invoice-title { text-align: right; }
    .invoice-title h1 { margin: 0; font-size: 28px; letter-spacing: 2px; }
    .info { display: flex; justify-content: space-between; margin-bottom: 20px; font-size: 14px; }
    table { width: 100%; border-collapse: collapse; margin-top: 10px; }
    th { background: #222; color: #fff; padding: 10px; font-size: 13px; text-align: left; }
    td { padding: 10px; border-bottom: 1px solid #ddd; font-size: 13px; }
    td.right, th.right { text-align: right; }
    .summary { margin-top: 20px; width: 100%; }
    .summary td { padding: 6px; font-size: 14px; }
    .summary .total { font-size: 18px; font-weight: bold; border-top: 2px solid #222; padding-top: 10px; }
    .footer { margin-top: 30px; text-align: center; font-size: 13px; color: #555; }
    
    /* BUTTON STYLING */
    .print-btn { text-align: center; margin-top: 30px; padding-bottom: 30px; }
    .print-btn button { 
        border: none; 
        padding: 12px 30px; /* Larger touch target */
        cursor: pointer; 
        font-size: 14px; 
        border-radius: 4px; 
        margin: 0 5px; /* Spacing between buttons */
        font-weight: 600;
    }
    .btn-print { background: #222; color: #fff; }
    .btn-back { background: #e0e0e0; color: #333; }
    .btn-back:hover { background: #d0d0d0; }

    @media print { 
        body { background: none; padding: 0; } 
        .invoice { box-shadow: none; padding: 0; width: 100%; } 
        .print-btn { display: none; } /* Hides both buttons */
    }
</style>
</head>
<body>

<div class="invoice">
    <div class="header">
        <div class="store">
            <h2><?= $store['name'] ?></h2>
            <small>
                <?= $store['address'] ?><br>
                Phone: <?= $store['phone'] ?><br>
                GSTIN: <?= $store['gstin'] ?>
            </small>
        </div>
        <div class="invoice-title">
            <h1>INVOICE</h1>
            <small>
                Invoice #: <?= $invoice['invoice_no'] ?><br>
                Date: <?= $invoice['date'] ?><br>
                Payment: <?= $invoice['payment_mode'] ?>
            </small>
        </div>
    </div>

    <div class="info">
        <div>
            <strong>Bill To</strong><br>
            <?= $invoice['customer'] ?><br>
            Phone: <?= $invoice['phone'] ?>
        </div>
    </div>

    <table>
        <tr>
            <th width="5%">#</th>
            <th width="35%">Item</th>
            <th class="right" width="10%">Qty</th>
            <th class="right" width="15%">Price</th>
            <th class="right" width="15%">Basic</th>
            <th class="right" width="20%">Net Amount</th>
        </tr>
        <?php foreach ($items as $i => $item): ?>
        <tr>
            <td><?= $i + 1 ?></td>
            <td><?= $item['name'] ?></td>
            <td class="right"><?= $item['qty'] ?></td>
            <td class="right"><?= number_format($item['price'], 2) ?></td>
            <td class="right"><?= number_format($item['basic'], 2) ?></td>
            <td class="right"><?= number_format($item['net_value'], 2) ?></td>
        </tr>
        <?php endforeach; ?>
    </table>

    <table class="summary">
        <tr>
            <td class="right" width="80%">Subtotal (Basic):</td>
            <td class="right">₹ <?= number_format($subtotal, 2) ?></td>
        </tr>
        
        <?php if($item_discount > 0): ?>
        <tr>
            <td class="right">Less: Item Discounts:</td>
            <td class="right text-danger">- ₹ <?= number_format($item_discount, 2) ?></td>
        </tr>
        <?php endif; ?>

        <tr>
            <td class="right">CGST (<?= $gst_percent/2 ?>%):</td>
            <td class="right">₹ <?= number_format($cgst, 2) ?></td>
        </tr>
        <tr>
            <td class="right">SGST (<?= $gst_percent/2 ?>%):</td>
            <td class="right">₹ <?= number_format($sgst, 2) ?></td>
        </tr>

        <?php if($overall_discount > 0): ?>
        <tr>
            <td class="right">Less: Overall Discount:</td>
            <td class="right text-danger">- ₹ <?= number_format($overall_discount, 2) ?></td>
        </tr>
        <?php endif; ?>

        <?php if($delivery > 0): ?>
        <tr>
            <td class="right">Add: Delivery Charges:</td>
            <td class="right">₹ <?= number_format($delivery, 2) ?></td>
        </tr>
        <?php endif; ?>

        <?php if($freight > 0): ?>
        <tr>
            <td class="right">Add: Freight Charges:</td>
            <td class="right">₹ <?= number_format($freight, 2) ?></td>
        </tr>
        <?php endif; ?>

        <tr class="total">
            <td class="right">Grand Total:</td>
            <td class="right">₹ <?= number_format($grand_total, 2) ?></td>
        </tr>
    </table>

    <div class="footer">
        Thank you for shopping with us! <br>
        <em>Goods once sold will not be taken back.</em>
    </div>
</div>

<div class="print-btn">
    <a href="index.php?r=sale" class="btn-back">⬅ Back</a>
    
    <button class="btn-print" onclick="window.print()">🖨️ Print Invoice</button>
</div>

</body>
</html>