<?php
require_once __DIR__ . "/../db.php";
require_once __DIR__ . "/../session.php";

requireAuth();

$current_business = getCurrentBusiness();
if (!$current_business) {
    header('Location: ' . BASE_URL . '/public/login.php');
    exit;
}
$message = "";
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Create Account</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <style>
        /* ===== GLOBAL ===== */
        body { 
            /* Merged background styles so image works */
            background-image: url("<?= BASE_URL ?>/public/grocery.png");
            background-size: cover;
            background-repeat: no-repeat;
            background-attachment: fixed;
            background-position: center;
            background-color: #f4f6f9; /* Fallback */
            font-size: 14px;
        }

        /* ===== PAGE WRAPPER ===== */
        .page {
            max-width: 1320px;
            margin: 40px auto;
            padding: 0 20px;
        }

        /* ===== CARD ===== */
        .card {
            background: #fff;
            border-radius: 14px;
            box-shadow: 0 10px 30px rgba(0,0,0,.08);
            overflow: hidden;
        }

        /* ===== HEADER ===== */
        .card-header {
            background: linear-gradient(135deg, #005ad5, #007cf8);
            color: #fff;
            padding: 22px 30px;
            font-size: 22px;
            font-weight: 650;
        }

        /* ===== BODY ===== */
        .card-body {
            padding: 35px 40px 120px;
        }

        /* ===== SECTION ===== */
        .section {
            margin-bottom: 40px;
        }

        .section-title {
            font-size: 17px;
            font-weight: 600;
            margin-bottom: 18px;
            color: #003d80;
            border-left: 4px solid #007cf8;
            padding-left: 10px;
        }

        /* ===== GRID ===== */
        .grid-2,
        .grid-3 {
            display: grid;
            gap: 26px;
        }

        .grid-2 { grid-template-columns: repeat(2, 1fr); }
        .grid-3 { grid-template-columns: repeat(3, 1fr); }

        /* ===== FORM ===== */
        label {
            display: block;
            font-size: 13px;
            font-weight: 600;
            margin-bottom: 6px;
            color: #374151;
        }

        input, select {
            width: 100%;
            padding: 13px 14px;
            border-radius: 7px;
            border: 1px solid #d1d5db;
            font-size: 14px;
            background: #f9fafb;
            box-sizing: border-box; /* Ensures padding doesn't break width */
        }

        input:focus, select:focus {
            outline: none;
            border-color: #007cf8;
            background: #fff;
            box-shadow: 0 0 0 2px rgba(0,124,248,.15);
        }

        /* ===== MESSAGE ===== */
        .message {
            background: #ecfdf5;
            color: #065f46;
            border-left: 5px solid #10b981;
            padding: 14px 18px;
            border-radius: 8px;
            font-weight: 600;
            margin-bottom: 25px;
            display: <?= $message ? 'block' : 'none'; ?>;
        }

        /* ===== FOOTER ACTION BAR ===== */
        .action-bar {
            position: sticky;
            bottom: 0;
            background: #ffffff;
            border-top: 1px solid #e5e7eb;
            padding: 18px 40px;
            display: flex;
            justify-content: flex-end;
            gap: 15px;
            z-index: 10;
        }

        .btn {
            padding: 14px 32px;
            font-size: 15px;
            font-weight: 600;
            border-radius: 8px;
            cursor: pointer;
            border: none;
        }

        .btn-primary {
            background: #007cf8;
            color: white;
        }

        .btn-primary:hover {
            background: #0062c7;
        }

        .btn-secondary {
            background: #e5e7eb;
            color: #374151;
        }

        /* ===== MOBILE RESPONSIVE FIXES ===== */
        @media (max-width: 768px) {
            /* Remove huge margins on mobile */
            .page {
                margin: 10px auto;
                padding: 0 10px;
            }

            /* Stack all grids into a single column */
            .grid-2, .grid-3 {
                grid-template-columns: 1fr;
                gap: 15px;
            }

            /* Reduce padding inside card */
            .card-body {
                padding: 20px;
            }

            .card-header {
                padding: 15px 20px;
                font-size: 18px;
            }

            /* Adjust Action Bar for mobile */
            .action-bar {
                padding: 15px 20px;
                justify-content: space-between; 
            }

            .btn {
                padding: 12px 20px;
                width: 48%; /* Buttons share width */
                font-size: 14px;
                text-align: center;
            }
        }
    </style>
</head>

<body>

<div class="page">
    <div class="card">

        <div class="card-header">
            Create Account
        </div>

        <form method="POST" action="<?= BASE_URL ?>/public/?r=create_accounts/create">

            <div class="card-body">

                <div class="message"><?= $message ?></div>

                <div class="section">
                    <div class="section-title">Basic Information</div>

                    <div class="grid-2">
                        <div>
                            <label>Name</label>
                            <input type="text" name="name" required>
                        </div>
                        <div>
                            <label>Print As</label>
                            <input type="text" name="print_as">
                        </div>
                    </div>

                    <div class="grid-3" style="margin-top:22px">
                        <div>
                            <label>Group</label>
                            <select name="group_name" required>
                                <option value="">Select</option>
                                <option>SUPPLIERS</option>
                                <option>CUSTOMERS</option>
                            </select>
                        </div>
                        <div>
                            <label>Opening Balance</label>
                            <input type="number" step="0.01" name="opening_balance">
                        </div>
                        <div>
                            <label>Dr / Cr</label>
                            <select name="drcr">
                                <option>Dr</option>
                                <option>Cr</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="section">
                    <div class="section-title">Address Details</div>

                    <div class="grid-2">
                        <div>
                            <label>Address Line 1</label>
                            <input type="text" name="address1">
                        </div>
                        <div>
                            <label>Address Line 2</label>
                            <input type="text" name="address2">
                        </div>
                    </div>

                    <div class="grid-3" style="margin-top:22px">
                        <div>
                            <label>City</label>
                            <input type="text" name="city">
                        </div>
                        <div>
                            <label>Pincode</label>
                            <input type="text" name="pincode">
                        </div>
                        <div>
                            <label>State</label>
                            <input type="text" name="state" value="West Bengal">
                        </div>
                    </div>
                </div>

                <div class="section">
                    <div class="section-title">Contact Details</div>

                    <div class="grid-3">
                        <div>
                            <label>Mobile</label>
                            <input type="text" name="mobile">
                        </div>
                        <div>
                            <label>Phone</label>
                            <input type="text" name="phone">
                        </div>
                        <div>
                            <label>Email</label>
                            <input type="email" name="email">
                        </div>
                    </div>

                    <div class="grid-2" style="margin-top:22px">
                        <div>
                            <label>Contact Person</label>
                            <input type="text" name="contact_person">
                        </div>
                        <div>
                            <label>PAN Card No</label>
                            <input type="text" name="pan">
                        </div>
                    </div>
                </div>

            </div>

            <div class="action-bar">
                <button type="reset" class="btn btn-secondary">Reset</button>
                <button type="submit" class="btn btn-primary">Save Account</button>
            </div>

        </form>

    </div>
</div>

</body>
</html>