# PHP + MySQL Restaurant Billing (Port)

This is a minimal PHP (no framework) + MySQL port of your Flask/SQLite app.

## Features
- Categories & Items CRUD
- Purchase Entry & Supplier management
- Create orders, add/remove items, discounts
- [x] Payment & Receipt entry for financial tracking
- [x] GST calculation, payment (mark as PAID), cancel
- [x] Advanced Reports:
    - **Stock Report**: Track purchases, sales, and inventory levels.
    - **Cash/Credit Report**: Consolidated view of transactions by payment term for both Sales and Purchases.
    - **Party Balances**: Real-time credit/debit balances for customers and suppliers.
    - **Detailed Ledgers**: Date-wise transaction history for every customer/supplier.
- Dashboard with quick access to new orders and logout
- Receipt page, basic reports + CSV export
- Business settings

## Structure
```
public/          # Web root (accessible via browser)
  index.php      # Main router and controller
  login.php      # User login
  register.php   # Business registration
src/
  config.php     # Configuration and environment variables
  db.php         # Database connection & Auto-migration logic
  helpers.php    # UI rendering & utility functions
  views/         # UI templates (Bootstrap 5)
db/
  grocery.sql    # Complete MySQL schema dump
  migrate.php    # Manual migration script
```

## Setup & Self-Healing
1. **Database**: Create a MySQL database (e.g., `grocery`).
2. **Environment**: Copy `.env.example` to `.env` and set your database credentials.
3. **Auto-Migration**: The system features a "self-healing" database. Upon the first page load, `src/db.php` will automatically:
   - Create the `orders`, `order_items`, `customer`, `purchases`, `purchase_items`, and `payments` tables if they are missing.
   - Add the `logo` column to the `settings` table and `payment_terms` to the `purchases` table if they don't exist.
4. **Manual Setup**: If you prefer manual setup, import `db/grocery.sql`.
5. **Web Server**: Point your web server to the project root or the `public/` directory.

### Nginx (example)
```
server {
  listen 80;
  server_name example.com;
  root /var/www/php_restaurant_billing/public;

  index index.php;
  location / {
    try_files $uri /index.php?$query_string;
  }
  location ~ \.php$ {
    include fastcgi_params;
    fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
    fastcgi_pass unix:/run/php/php8.2-fpm.sock;
  }
}
```

## Notes
- No auth is implemented; add HTTP auth or login if needed.
- For production, disable `display_errors` and handle CSRF as needed.
- You can extend this to use a lightweight router or a framework (Laravel/Slim) later.
