<?php
/**
 * Simple API Test Script
 * Run this to test if your APIs are working correctly
 */

// Configuration
$base_url = 'http://localhost/php_restaurant_billing/src/api/';

// Test function
function testAPI($url, $method = 'GET', $data = null, $headers = []) {
    $ch = curl_init();
    
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    if ($method === 'POST' || $method === 'PUT') {
        curl_setopt($ch, CURLOPT_POST, true);
        if ($data) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            $headers[] = 'Content-Type: application/json';
        }
    }
    
    if (!empty($headers)) {
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    }
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    return [
        'status_code' => $http_code,
        'response' => json_decode($response, true)
    ];
}

echo "<h1>Restaurant Billing API Test</h1>\n";

// Test 1: Authentication
echo "<h2>1. Testing Authentication</h2>\n";
$result = testAPI($base_url . 'auth.php?action=login', 'POST', [
    'username' => 'admin',
    'password' => 'admin123'
]);

if ($result['status_code'] == 200 && $result['response']['status']) {
    echo "✅ Login successful<br>\n";
    $token = $result['response']['data']['token'];
    $auth_header = ['Authorization: Bearer ' . $token];
} else {
    echo "❌ Login failed<br>\n";
    echo "Response: " . json_encode($result['response']) . "<br>\n";
    $auth_header = [];
}

// Test 2: Get Settings
echo "<h2>2. Testing Settings API</h2>\n";
$result = testAPI($base_url . 'settings.php?action=get', 'GET', null, $auth_header);
if ($result['status_code'] == 200 && $result['response']['status']) {
    echo "✅ Settings API working<br>\n";
} else {
    echo "❌ Settings API failed<br>\n";
}

// Test 3: Get Categories
echo "<h2>3. Testing Categories API</h2>\n";
$result = testAPI($base_url . 'categories.php?action=list', 'GET', null, $auth_header);
if ($result['status_code'] == 200 && $result['response']['status']) {
    echo "✅ Categories API working<br>\n";
} else {
    echo "❌ Categories API failed<br>\n";
}

// Test 4: Get Items
echo "<h2>4. Testing Items API</h2>\n";
$result = testAPI($base_url . 'items.php?action=list', 'GET', null, $auth_header);
if ($result['status_code'] == 200 && $result['response']['status']) {
    echo "✅ Items API working<br>\n";
} else {
    echo "❌ Items API failed<br>\n";
}

// Test 5: Get Orders
echo "<h2>5. Testing Orders API</h2>\n";
$result = testAPI($base_url . 'orders.php?action=list', 'GET', null, $auth_header);
if ($result['status_code'] == 200 && $result['response']['status']) {
    echo "✅ Orders API working<br>\n";
} else {
    echo "❌ Orders API failed<br>\n";
}

// Test 6: Get Dashboard
echo "<h2>6. Testing Dashboard API</h2>\n";
$result = testAPI($base_url . 'dashboard.php?action=stats', 'GET', null, $auth_header);
if ($result['status_code'] == 200 && $result['response']['status']) {
    echo "✅ Dashboard API working<br>\n";
} else {
    echo "❌ Dashboard API failed<br>\n";
}

// Test 7: Get Customers
echo "<h2>7. Testing Customers API</h2>\n";
$result = testAPI($base_url . 'customers.php?action=list', 'GET', null, $auth_header);
if ($result['status_code'] == 200 && $result['response']['status']) {
    echo "✅ Customers API working<br>\n";
} else {
    echo "❌ Customers API failed<br>\n";
}

echo "<h2>Test Complete!</h2>\n";
echo "<p>If all tests show ✅, your APIs are ready for Android integration!</p>\n";
echo "<p>Check the API_DOCUMENTATION.md file for detailed usage instructions.</p>\n";
?>
