<?php
require_once __DIR__ . "/../db.php";
require_once __DIR__ . "/../session.php";

requireAuth();

$current_business = getCurrentBusiness();
if (!$current_business) {
    echo "<script>window.location.href='" . BASE_URL . "/public/login.php';</script>";
    exit;
}

$business_id = $current_business['business_id'];

/* =========================
   DELETE INVOICE TYPE
========================= */
if (isset($_GET['id'])) {
    $id = $_GET['id'];

    query(
        "DELETE FROM invoice_types 
         WHERE id = ? AND business_id = ? AND type_name != 'Sales'",
        [$id, $business_id]
    );

    echo "<script>window.location.href='" . BASE_URL . "/public/?r=settings';</script>";
    exit;
}

/* =========================
   FETCH SETTINGS
========================= */
$settings = one("SELECT * FROM settings WHERE id = ?", [$business_id]);

if (!$settings) {
    echo "<p class='alert alert-warning'>No settings found.</p>";
    exit;
}

/* =========================
   ENSURE SALES DEFAULT
========================= */
$sales = one(
    "SELECT * FROM invoice_types 
     WHERE business_id = ? AND type_name = 'Sales'",
    [$business_id]
);

if (!$sales) {
    query(
        "INSERT INTO invoice_types 
        (business_id, type_name, tax_type, prefix, start_number) 
        VALUES (?, 'Sales', 'exclusive', 'SAL-', 1)",
        [$business_id]
    );
}

/* =========================
   FETCH INVOICE TYPES
========================= */
$invoice_types = all_rows(
    "SELECT * FROM invoice_types WHERE business_id = ?",
    [$business_id]
);

/* =========================
   SORT: SALES FIRST
========================= */
usort($invoice_types, function ($a, $b) {
    if ($a['type_name'] === 'Sales') return -1;
    if ($b['type_name'] === 'Sales') return 1;
    return 0;
});
?>

<style>
body {
    background-image: url("<?= BASE_URL ?>/public/grocery.png");
    background-size: cover;
    background-repeat: no-repeat;
    background-attachment: fixed;
}
.glass-container {
    background: rgba(255,255,255,0.9);
    border-radius: 12px;
    padding: 20px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    margin-bottom: 20px;
}
.table-glass {
    background: rgba(255,255,255,0.6);
}
</style>

<div class="container mt-4">

<!-- ================= GENERAL SETTINGS ================= -->
<div class="glass-container">
<h4 class="text-primary border-bottom pb-2">General Business Settings</h4>

<form class="row g-3" method="post" action="<?= BASE_URL ?>/public/?r=settings/save">
<div class="col-md-6">
<label>Business Name</label>
<input class="form-control" name="business_name" value="<?= e($settings['business_name']) ?>">
</div>

<div class="col-md-6">
<label>Phone</label>
<input class="form-control" name="phone" value="<?= e($settings['phone']) ?>">
</div>

<div class="col-md-12">
<label>Address</label>
<input class="form-control" name="address" value="<?= e($settings['address']) ?>">
</div>

<div class="col-md-6">
<label>GST Applicable?</label>
<select class="form-select" name="gst_applicable" id="gst_applicable">
<option value="1" <?= $settings['gst_applicable'] ? 'selected' : '' ?>>Yes</option>
<option value="0" <?= !$settings['gst_applicable'] ? 'selected' : '' ?>>No</option>
</select>
</div>

<div class="col-md-3" id="gst_rate_field" style="<?= !$settings['gst_applicable'] ? 'display:none;' : '' ?>">
<label>Default GST %</label>
<input class="form-control" type="number" step="0.01" name="gst_rate" value="<?= e($settings['gst_rate']) ?>">
</div>

<div class="col-md-3" id="gstin_field" style="<?= !$settings['gst_applicable'] ? 'display:none;' : '' ?>">
<label>GSTIN</label>
<input class="form-control" name="gstin" value="<?= e($settings['gstin']) ?>">
</div>

<div class="col-12 text-end">
<button class="btn btn-primary">Update Settings</button>
</div>
</form>
</div>

<!-- ================= INVOICE TYPES ================= -->
<div class="glass-container">
<h4 class="text-success border-bottom pb-2">Invoice Types</h4>

<table class="table table-bordered table-glass">
<thead class="table-light">
<tr>
<th>Type</th>
<th>Tax</th>
<th>Prefix</th>
<th>Start</th>
<th>Action</th>
</tr>
</thead>
<tbody>

<?php foreach ($invoice_types as $type): ?>
<tr>
<td class="fw-bold">
<?= $type['type_name'] ?>
<?php if ($type['type_name'] === 'Sales'): ?>
<span class="badge bg-warning ms-2">DEFAULT</span>
<?php endif; ?>
</td>

<td>
<span class="badge bg-<?= $type['tax_type'] === 'inclusive' ? 'success' : 'primary' ?>">
<?= ucfirst($type['tax_type']) ?>
</span>
</td>

<td><?= $type['prefix'] ?></td>
<td><?= $type['start_number'] ?></td>

<td>
<?php if ($type['type_name'] !== 'Sales'): ?>
<a href="<?= BASE_URL ?>/public/?r=settings&id=<?= $type['id'] ?>"
class="btn btn-sm btn-outline-danger"
onclick="return confirm('Delete invoice type?');">
Delete
</a>
<?php else: ?>
<span class="text-muted">Locked</span>
<?php endif; ?>
</td>
</tr>
<?php endforeach; ?>

</tbody>
</table>

<!-- ================= ADD TYPE ================= -->
<div class="card bg-light border-0 p-3 mt-3">
<h6 class="fw-bold">Add Invoice Type</h6>

<form action="<?= BASE_URL ?>/public/?r=settings/save_invoice_type" method="POST" class="row g-2">
<div class="col-md-3">
<input name="type_name" class="form-control form-control-sm" placeholder="Type Name" required>
</div>

<div class="col-md-3">
<select name="tax_type" class="form-select form-select-sm">
<option value="exclusive" selected>Exclusive</option>
<option value="inclusive">Inclusive</option>
</select>
</div>

<div class="col-md-2">
<input name="prefix" class="form-control form-control-sm" placeholder="Prefix">
</div>

<div class="col-md-2">
<input name="start_number" type="number" class="form-control form-control-sm" value="1">
</div>

<div class="col-md-2">
<button class="btn btn-success btn-sm w-100">Add</button>
</div>
</form>
</div>

</div>
</div>

<script>
document.getElementById("gst_applicable").addEventListener("change", function () {
document.getElementById("gst_rate_field").style.display = this.value == 1 ? "block" : "none";
document.getElementById("gstin_field").style.display = this.value == 1 ? "block" : "none";
});
</script>
