<?php

require_once __DIR__ . "/../db.php";
require_once __DIR__ . "/../session.php";

// Require authentication
requireAuth();

// Get current business
$current_business = getCurrentBusiness();
if (!$current_business) {
    header('Location: ' . BASE_URL . '/public/login.php');
    exit;
}

// Log activity
logActivity('dashboard_view', 'Viewed dashboard');

// Get orders for current business (assuming orders are linked to business via settings)
$business_id = $current_business['business_id'];
$openOrders = all_rows("SELECT * FROM orders WHERE business_id = ? AND status='OPEN' ORDER BY created_at DESC LIMIT 20", [$business_id]);
$recentPaid = all_rows("SELECT * FROM orders WHERE business_id = ? AND status='PAID' ORDER BY created_at DESC LIMIT 10", [$business_id]);
?>
<style>
  body {
    background-image: url("<?php echo BASE_URL; ?>/public/background.jpg");
    background-size: cover;
    background-repeat: no-repeat;
    background-attachment: fixed;
    background-position: center;
  }
  .container{
    background: rgba(255, 255, 255, 0.88);
    border-radius: 16px;
    padding: 1rem;
    box-shadow: 0 10px 30px rgba(0, 0, 0, .15);
    backdrop-filter: blur(2px);
  }
</style>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3>Dashboard</h3>
  <div class="btn-group">
    <a class="btn btn-primary" href="<?= BASE_URL ?>/public/?r=orders/new">New Order</a>
    <a class="btn btn-outline-danger" href="<?= BASE_URL ?>/public/logout.php" 
       onclick="return confirm('Are you sure you want to logout?')">Logout</a>
  </div>
</div>

<div class="row g-3">
  <div class="col-md-8">
    <div class="card">
      <div class="card-header">Open Orders</div>
      <div class="card-body table-responsive">
        <table class="table table-sm">
          <thead><tr><th>ID</th><th>Table</th><th>Total</th><th>Status</th><th>Actions</th></tr></thead>
          <tbody>
            <?php foreach($openOrders as $o): ?>
              <tr>
                <td><?= e($o['id']) ?></td>
                <td><?= e($o['table_no']) ?></td>
                <td>₹ <?= e(number_format($o['total'], 2)) ?></td>
                <td><?= e($o['status']) ?></td>
                <td><a class="btn btn-sm btn-outline-primary" href="<?= BASE_URL ?>/public/?r=orders/show&id=<?= e($o['id']) ?>">Open</a></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  <div class="col-md-4">
    <div class="card">
      <div class="card-header">Recent Payments</div>
      <div class="card-body">
        <ul class="list-group list-group-flush">
          <?php foreach($recentPaid as $p): ?>
            <li class="list-group-item d-flex justify-content-between">
              <span>#<?= e($p['id']) ?> (Table <?= e($p['table_no']) ?>)</span>
              <strong>₹ <?= e(number_format($p['total'],2)) ?></strong>
            </li>
          <?php endforeach; ?>
        </ul>
      </div>
    </div>
  </div>
</div>
