<?php

require_once __DIR__ . "/../db.php";
require_once __DIR__ . "/../session.php";

// Require authentication
requireAuth();

// Get current business
$current_business = getCurrentBusiness();
if (!$current_business) {
    header('Location: ' . BASE_URL . '/public/login.php');
    exit;
}
$message = "";
$business_id = $current_business['business_id'];
?>

<!DOCTYPE html>
<html>

<head>
    <title>Create Account</title>
    <style>
        body {
            font-family: "Segoe UI", Arial, sans-serif;
            background: #f5f6f8;
            margin: 0;
            padding: 0;
        }

        .container {
            width: 1200px;
            /* ⭐ Wider like your screenshot */
            margin: 62px auto;
            background: white;
            border-radius: 12px;
        }

        h2 {
            margin: 0 0 25px 0;
            color: #1a1a1a;
            font-weight: 650;
            background: #007cf8;
            padding: 14px 22px;
            color: white;
            border-radius: 6px;
            font-size: 20px;
        }

        h3 {
            margin-top: 35px;
            color: #003d80;
            font-weight: 600;
            font-size: 17px;
            border-bottom: 2px solid #e5e7eb;
            padding-bottom: 6px;
        }

        .row {
            display: flex;
            gap: 25px;
            margin-bottom: 20px;
        }

        .col {
            flex: 1;
        }

        label {
            display: block;
            font-size: 14px;
            font-weight: 600;
            margin-bottom: 6px;
            color: #333;
        }

        input,
        select {
            width: 100%;
            padding: 13px;
            border: 1px solid #ccd1d9;
            border-radius: 6px;
            font-size: 14px;
            background: #fbfcfe;
            transition: 0.2s;
        }

        input:focus,
        select:focus {
            border-color: #007cf8;
            background: #fff;
            box-shadow: 0 0 4px rgba(0, 124, 248, 0.35);
            outline: none;
        }

        .btn {
            background: #007cf8;
            color: white;
            padding: 15px 25px;
            border: none;
            border-radius: 6px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            margin-top: 30px;
            width: 240px;
            transition: 0.2s;
        }

        .btn:hover {
            background: #0062c7;
        }

        .message {
            padding: 14px;
            background: #d4edda;
            border-left: 5px solid #28a745;
            color: #155724;
            margin-bottom: 20px;
            border-radius: 5px;
            display: <?=$message ? 'block': 'none';
            ?>;
            font-weight: 600;
        }
    </style>

</head>

<body>
    <div class="container">
        <h2>Create Account</h2>

        <div class="message">
            <?= $message ?>
        </div>

        <form method="POST" action="<?= BASE_URL ?>/public/?r=create_accounts/create">

            <div class="row">
                <div class="col">
                    <label>Name</label>
                    <input type="text" name="name" required>
                </div>

                <div class="col">
                    <label>Print As</label>
                    <input type="text" name="print_as">
                </div>
            </div>

            <div class="row">
                <div class="col">
                    <label>Group</label>
                    <select name="group_name" required>
                        <option value="">Select Group</option>
                        <option value="SUPPLIERS">SUPPLIERS</option>
                        <option value="CUSTOMERS">CUSTOMERS</option>
                    </select>
                </div>

                <div class="col">
                    <label>Opening Balance</label>
                    <input type="number" step="0.01" name="opening_balance">
                </div>

                <div class="col">
                    <label>Dr / Cr</label>
                    <select name="drcr">
                        <option value="Dr">Dr</option>
                        <option value="Cr">Cr</option>
                    </select>
                </div>
            </div>

            <h3>Address Details</h3>

            <div class="row">
                <div class="col">
                    <label>Address Line 1</label>
                    <input type="text" name="address1">
                </div>
                <div class="col">
                    <label>Address Line 2</label>
                    <input type="text" name="address2">
                </div>
            </div>

            <div class="row">
                <div class="col">
                    <label>City</label>
                    <input type="text" name="city">
                </div>

                <div class="col">
                    <label>Pincode</label>
                    <input type="text" name="pincode">
                </div>

                <div class="col">
                    <label>State</label>
                    <input type="text" name="state" value="West Bengal">
                </div>
            </div>

            <h3>Contact Details</h3>

            <div class="row">
                <div class="col">
                    <label>Mobile</label>
                    <input type="text" name="mobile">
                </div>

                <div class="col">
                    <label>Phone</label>
                    <input type="text" name="phone">
                </div>

                <div class="col">
                    <label>Email</label>
                    <input type="email" name="email">
                </div>
            </div>

            <div class="row">
                <div class="col">
                    <label>Contact Person</label>
                    <input type="text" name="contact_person">
                </div>

                <div class="col">
                    <label>PAN Card No(optional)</label>
                    <input type="text" name="pan">
                </div>
            </div>

            <button class="btn" type="submit">Save Account</button>

        </form>
    </div>

</body>

</html>