<?php
require_once __DIR__ . "/../db.php";
require_once __DIR__ . "/../session.php";

requireAuth();
$current_business = getCurrentBusiness();
if (!$current_business) {
    header('Location: ' . BASE_URL . '/public/login.php');
    exit;
$business_id = $current_business['business_id'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Add New Item</title>
    <style>
        body { background-color: #f0f2f5; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
        .card { border: none; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); }
        .form-label { font-weight: 600; font-size: 0.9rem; color: #555; }
        .section-title { font-size: 1.1rem; font-weight: 700; color: #0d6efd; margin-bottom: 15px; border-bottom: 2px solid #e9ecef; padding-bottom: 8px; }
        .unit-preview { background: #e7f1ff; color: #0c63e4; padding: 10px; border-radius: 8px; font-weight: bold; font-size: 0.9rem; display: none; }
    </style>
</head>

<body>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            
            <form action="<?= BASE_URL ?>/public/?r=items/save_item" method="POST" enctype="multipart/form-data">
                <div class="card">
                    <div class="card-header bg-white py-3 border-bottom-0">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="mb-0 text-dark fw-bold">📦 Add New Product</h4>
                            <a href="<?= BASE_URL ?>/public/?r=items" class="btn btn-outline-secondary btn-sm">Back to List</a>
                        </div>
                    </div>

                    <div class="card-body p-4">

                        <h5 class="section-title">1. Basic Details</h5>
                        <div class="row g-3 mb-4">
                            <div class="col-md-6">
                                <label class="form-label">Item Name <span class="text-danger">*</span></label>
                                <input type="text" name="item_name" class="form-control" placeholder="e.g. Parle-G Biscuit" required>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Short Name / SKU</label>
                                <input type="text" name="short_name" class="form-control" placeholder="e.g. PG-100">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">HSN Code</label>
                                <input type="text" name="hsn_code" class="form-control" placeholder="e.g. 1905">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Company / Brand</label>
                                <input type="text" name="company" class="form-control">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Item Group</label>
                                <input type="text" name="item_group" list="groupList" class="form-control" placeholder="Select or Type">
                                <datalist id="groupList">
                                    <option value="Grocery"><option value="Electronics"><option value="Garments">
                                </datalist>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">GST Tax Slab</label>
                                <select name="tax_slab" class="form-select">
                                    <option value="0">0% (Nil Rated)</option>
                                    <option value="5">5% GST</option>
                                    <option value="12">12% GST</option>
                                    <option value="18">18% GST</option>
                                    <option value="28">28% GST</option>
                                </select>
                            </div>
                        </div>

                        <h5 class="section-title">2. Unit & Conversion</h5>
                        <div class="row g-3 mb-2">
                            <div class="col-md-4">
                                <label class="form-label">Primary Unit (Base) <span class="text-danger">*</span></label>
                                <input type="text" name="primary_unit" id="primary_unit" class="form-control" list="unitList" placeholder="e.g. Pcs, gms" required oninput="updateUnitLogic()">
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Alternate Unit (Optional)</label>
                                <input type="text" name="alternate_unit" id="alternate_unit" class="form-control" list="altUnitList" placeholder="e.g. Box, Carton" oninput="updateUnitLogic()">
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Conversion Factor</label>
                                <input type="number" step="any" name="conversion_factor" id="conversion_factor" class="form-control" value="1" oninput="updateUnitLogic()">
                            </div>
                            
                            <datalist id="unitList"><option value="Pcs"><option value="Kg"><option value="Ltr"><option value="Mtr"></datalist>
                            <datalist id="altUnitList"><option value="Box"><option value="Carton"><option value="Bundle"><option value="Pack"></datalist>
                        </div>
                        
                        <div class="row mb-4">
                            <div class="col-12">
                                <div id="unitPreview" class="unit-preview text-center">
                                    ℹ️ 1 <span id="lbl_alt">Box</span> contains <b><span id="lbl_factor">1</span></b> <span id="lbl_base">Pcs</span>
                                </div>
                            </div>
                        </div>

                        <h5 class="section-title">3. Pricing & Stock</h5>
                        <div class="row g-3 mb-4">
                            <div class="col-md-3">
                                <label class="form-label">Pricing Per?</label>
                                <select name="price_per" id="price_per_select" class="form-select">
                                    <option value="Primary">Primary Unit</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Purchase Price</label>
                                <div class="input-group">
                                    <span class="input-group-text">₹</span>
                                    <input type="number" step="0.01" name="purchase_price" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Sale Price</label>
                                <div class="input-group">
                                    <span class="input-group-text">₹</span>
                                    <input type="number" step="0.01" name="sale_price" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">MRP</label>
                                <div class="input-group">
                                    <span class="input-group-text">₹</span>
                                    <input type="number" step="0.01" name="mrp" class="form-control">
                                </div>
                            </div>
                        </div>

                        <div class="row g-3 mb-4 bg-light p-3 rounded">
                            <div class="col-md-6">
                                <label class="form-label">Opening Stock (In Base Unit)</label>
                                <input type="number" step="0.01" name="opening_qty_kg" class="form-control" placeholder="e.g. 100">
                                <small class="text-muted">Enter quantity in <span id="stock_hint">Primary Unit</span></small>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Product Image</label>
                                <input type="file" name="img" class="form-control">
                            </div>
                        </div>

                    </div>
                    
                    <div class="card-footer bg-white text-end py-3">
                        <button type="submit" class="btn btn-success btn-lg px-5 shadow-sm">
                            <i class="bi bi-save"></i> Save Product
                        </button>
                    </div>
                </div>
            </form>
            
        </div>
    </div>
</div>

<script>
    function updateUnitLogic() {
        let base = document.getElementById("primary_unit").value || 'Unit';
        let alt  = document.getElementById("alternate_unit").value;
        let factor = document.getElementById("conversion_factor").value || 1;
        
        let preview = document.getElementById("unitPreview");
        let priceSelect = document.getElementById("price_per_select");

        document.getElementById("lbl_base").innerText = base;
        document.getElementById("lbl_alt").innerText = alt || base;
        document.getElementById("lbl_factor").innerText = factor;
        document.getElementById("stock_hint").innerText = base;

        if(alt && alt !== base) {
            preview.style.display = "block";
            priceSelect.innerHTML = `
                <option value="${base}">Per ${base}</option>
                <option value="${alt}">Per ${alt}</option>
            `;
        } else {
            preview.style.display = "none";
            priceSelect.innerHTML = `<option value="${base}">Per ${base}</option>`;
        }
    }
</script>

</body>
</html>