<?php
require_once __DIR__ . '/../src/db.php';
require_once __DIR__ . '/../src/session.php';

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $business_name = trim($_POST['business_name']);
    $phone         = trim($_POST['phone']);
    $password      = trim($_POST['password']);

    // Fetch user details
    $user = one("SELECT * FROM settings WHERE business_name = ? AND phone = ?", [$business_name, $phone]);

    if ($user) {
        if (password_verify($password, $user['password'])) {
            $subscription = one("SELECT * FROM subscriptions WHERE restaurant_id = ? ORDER BY id DESC LIMIT 1", [$user['id']]);
            if ($subscription) {
                $now = date('Y-m-d H:i:s');
                if ($subscription['status'] === 'expired' || $subscription['expiry_date'] < $now) {
                    authenticateBusiness($user['id'], $user['business_name'], 'admin');
                    logActivity('login_attempt', 'Login with expired subscription');
                    header("Location: renewal_request.php");
                    exit;
                }
            } else {
                authenticateBusiness($user['id'], $user['business_name'], 'admin');
                logActivity('login_attempt', 'Login with no subscription');
                header("Location: renewal_request.php");
                exit;
            }

            authenticateBusiness($user['id'], $user['business_name'], 'admin');
            logActivity('login_success', 'Successful login');
            header("Location: index.php");
            exit;

        } else {
            $error = "❌ Incorrect password!";
            logActivity('login_failed', 'Incorrect password for business: ' . $business_name);
        }
    } else {
        $error = "⚠️ No account found with that Business Name and Phone!";
        logActivity('login_failed', 'Business not found: ' . $business_name);
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Business Login | Restaurant Billing</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
/* --- Reset --- */
* {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
  font-family: 'Poppins', sans-serif;
}

/* --- Background --- */
body {
  background-image: url("<?php echo BASE_URL; ?>/public/background.jpg");
  height: 100vh;
  display: flex;
  justify-content: center;
  align-items: center;
}

/* --- Container --- */
.container {
  background: #fff;
  width: 90%;
  max-width: 380px; /* keeps desktop look */
  padding: 30px 20px;
  border-radius: 15px;
  box-shadow: 0 8px 25px rgba(0,0,0,0.2);
  text-align: center;
  animation: fadeIn 0.8s ease;
}


/* --- Title --- */
.container h2 {
  color: #333;
  font-weight: 600;
  margin-bottom: 25px;
  font-size: 26px;
}

/* --- Form Inputs --- */
.container input[type="text"],
.container input[type="password"] {
  width: 100%;
  padding: 12px;
  margin: 10px 0 20px 0;
  border: 1px solid #ccc;
  border-radius: 8px;
  font-size: 15px;
  transition: all 0.3s ease;
}

.container input:focus {
  border-color: #4f46e5;
  outline: none;
  box-shadow: 0 0 6px rgba(79,70,229,0.3);
}

/* --- Button --- */
.container button {
  width: 100%;
  padding: 12px;
  border: none;
  background: #4f46e5;
  color: white;
  font-weight: 600;
  border-radius: 8px;
  font-size: 16px;
  cursor: pointer;
  transition: background 0.3s ease;
}

.container button:hover {
  background: #3730a3;
}

/* --- Error Message --- */
.container p[style] {
  background: #fee2e2;
  color: #b91c1c;
  padding: 10px;
  border-radius: 6px;
  margin-bottom: 15px;
  font-size: 14px;
}

/* --- Footer --- */
.container p {
  margin-top: 20px;
  font-size: 14px;
}

.container a {
  color: #4f46e5;
  text-decoration: none;
  font-weight: 500;
}

.container a:hover {
  text-decoration: underline;
}

/* --- Animation --- */
@keyframes fadeIn {
  from { opacity: 0; transform: translateY(-15px); }
  to { opacity: 1; transform: translateY(0); }
}

/* --- Responsive --- */
@media (max-width: 420px) {
  .container {
    width: 90%;
    padding: 30px 20px;
  }
}
</style>
</head>
<body>
<div class="container">
  <h2>Business Login</h2>
  <?php if(isset($error)) echo "<p style='color:red;'>$error</p>"; ?>

  <form method="POST">
      <input type="text" name="business_name" placeholder="Business Name" required>
      <input type="text" name="phone" placeholder="Phone Number" required>
      <input type="password" name="password" placeholder="Password" required>
      <button type="submit">Login</button>
  </form>

  <p>New Business? <a href="register.php">Register</a></p>
</div>
</body>
</html>
