# PHP + MySQL Restaurant Billing (Port)

This is a minimal PHP (no framework) + MySQL port of your Flask/SQLite app.

## Features
- Categories & Items CRUD
- Create orders, add/remove items, discounts
- GST calculation, payment (mark as PAID), cancel
- Receipt page, basic reports + CSV export
- Business settings

## Structure
```
public/          # web root
  index.php      # simple router
src/
  config.php     # reads .env
  db.php         # PDO connection & helpers
  helpers.php    # render/redirect helpers
  views/         # templates (Bootstrap 5)
db/
  schema.sql     # MySQL schema
.env.example
```

## Setup
1. Create a DB and user:
   ```sql
   CREATE DATABASE restaurant_billing CHARACTER SET utf8mb4;
   CREATE USER 'rb_user'@'%' IDENTIFIED BY 'strongpass';
   GRANT ALL PRIVILEGES ON restaurant_billing.* TO 'rb_user'@'%';
   FLUSH PRIVILEGES;
   ```
2. Import schema:
   ```bash
   mysql -u rb_user -p restaurant_billing < db/schema.sql
   ```
3. Copy and edit env:
   ```bash
   cp .env.example .env
   # set DB_HOST, DB_NAME, DB_USER, DB_PASS
   ```
4. Point your web server to `public/` as the document root.

### Nginx (example)
```
server {
  listen 80;
  server_name example.com;
  root /var/www/php_restaurant_billing/public;

  index index.php;
  location / {
    try_files $uri /index.php?$query_string;
  }
  location ~ \.php$ {
    include fastcgi_params;
    fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
    fastcgi_pass unix:/run/php/php8.2-fpm.sock;
  }
}
```

## Notes
- No auth is implemented; add HTTP auth or login if needed.
- For production, disable `display_errors` and handle CSRF as needed.
- You can extend this to use a lightweight router or a framework (Laravel/Slim) later.
