<?php
include 'db.php';

// --- 1. HANDLE DELETE ACTION (BACKEND) ---
if (isset($_GET['delete_id'])) {
    $id = intval($_GET['delete_id']);
    
    if($id > 0){
        $stmt = $con->prepare("DELETE FROM hotel_enquiry WHERE id = ?");
        $stmt->bind_param("i", $id);
        
        if ($stmt->execute()) {
            header("Location: index.php?msg=deleted");
            exit();
        } else {
            echo "Error deleting record."; 
        }
        $stmt->close();
    }
}

// --- 2. FETCH STATS ---
$total_hotels = $con->query("SELECT COUNT(*) as count FROM hotel_enquiry")->fetch_assoc()['count'] ?? 0;
$total_rooms_result = $con->query("SELECT SUM(total_rooms) as count FROM hotel_enquiry")->fetch_assoc();
$total_rooms = $total_rooms_result['count'] ?? 0;

// --- 3. FETCH ALL RECORDS ---
$sql = "SELECT * FROM hotel_enquiry ORDER BY id DESC";
$result = $con->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - Hotel Partners</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
    </style>
</head>
<body class="bg-slate-50 min-h-screen">

    <nav class="bg-slate-900 text-white shadow-lg sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16 items-center">
                <div class="flex items-center gap-3">
                    <div class="bg-blue-600 p-2 rounded-lg">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                        </svg>
                    </div>
                    <span class="font-bold text-xl tracking-tight">HotelAdmin</span>
                </div>
                <div class="flex gap-4">
                    <a href="../index.php" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg text-sm font-semibold transition-colors flex items-center gap-2">
                        <span>+ Add New Hotel</span>
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        
        <?php if(isset($_GET['msg']) && $_GET['msg'] == 'deleted'): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-6 flex items-center gap-2" role="alert">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" /></svg>
            <span class="block sm:inline">Record deleted successfully.</span>
        </div>
        <?php endif; ?>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
            <div class="bg-white p-6 rounded-2xl shadow-sm border border-slate-100 flex items-center justify-between">
                <div>
                    <p class="text-slate-500 text-sm font-semibold uppercase tracking-wider">Total Hotels</p>
                    <h3 class="text-3xl font-bold text-slate-800 mt-1"><?php echo $total_hotels; ?></h3>
                </div>
                <div class="bg-blue-50 p-3 rounded-full text-blue-600">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" /></svg>
                </div>
            </div>

            <div class="bg-white p-6 rounded-2xl shadow-sm border border-slate-100 flex items-center justify-between">
                <div>
                    <p class="text-slate-500 text-sm font-semibold uppercase tracking-wider">Total Inventory</p>
                    <h3 class="text-3xl font-bold text-slate-800 mt-1"><?php echo $total_rooms; ?> <span class="text-lg text-slate-400 font-normal">Rooms</span></h3>
                </div>
                <div class="bg-green-50 p-3 rounded-full text-green-600">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 5v2m0 4v2m0 4v2M5 5a2 2 0 00-2 2v3a2 2 0 110 4v3a2 2 0 002 2h14a2 2 0 002-2v-3a2 2 0 110-4V7a2 2 0 00-2-2H5z" /></svg>
                </div>
            </div>
            
            <div class="bg-blue-600 p-6 rounded-2xl shadow-lg shadow-blue-200 text-white flex flex-col justify-center items-start">
                <p class="text-blue-100 text-sm font-semibold uppercase tracking-wider">Dashboard Summary</p>
                <div class="mt-2 text-sm text-blue-50 opacity-90">Manage your hotel partners and oversee inventory.</div>
            </div>
        </div>

        <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden">
            <div class="px-6 py-5 border-b border-slate-100 flex justify-between items-center">
                <h3 class="text-lg font-bold text-slate-800">Hotel Directory</h3>
            </div>
            
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead>
                        <tr class="bg-slate-50 text-slate-500 text-xs uppercase tracking-wider">
                            <th class="px-6 py-4 font-semibold">ID</th>
                            <th class="px-6 py-4 font-semibold">Hotel Details</th>
                            <th class="px-6 py-4 font-semibold">Owner Info</th>
                            <th class="px-6 py-4 font-semibold">Location</th>
                            <th class="px-6 py-4 font-semibold">Rates (W/E)</th>
                            <th class="px-6 py-4 font-semibold text-right">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-100">
                        <?php if ($result && $result->num_rows > 0): ?>
                            <?php while($row = $result->fetch_assoc()): ?>
                            <tr class="hover:bg-slate-50 transition-colors">
                                <td class="px-6 py-4 text-slate-400 font-mono text-sm">#<?php echo $row['id']; ?></td>
                                
                                <td class="px-6 py-4">
                                    <div class="font-bold text-slate-800"><?php echo htmlspecialchars($row['hotel_name'] ?? ''); ?></div>
                                    <div class="text-sm text-slate-500">
                                        <?php echo htmlspecialchars($row['hotel_star_rating'] ?? ''); ?> • <?php echo $row['total_rooms'] ?? 0; ?> Rooms
                                    </div>
                                    <div class="text-xs text-slate-400 mt-1">GST: <?php echo htmlspecialchars($row['gst_no'] ?? ''); ?></div>
                                </td>

                                <td class="px-6 py-4">
                                    <div class="text-slate-700 font-medium"><?php echo htmlspecialchars($row['owner_name'] ?? ''); ?></div>
                                    <div class="text-sm text-blue-600"><?php echo htmlspecialchars($row['owner_number'] ?? ''); ?></div>
                                </td>

                                <td class="px-6 py-4">
                                    <div class="text-sm text-slate-600 max-w-xs truncate" title="<?php echo htmlspecialchars($row['address'] ?? ''); ?>">
                                        <?php echo htmlspecialchars($row['address'] ?? ''); ?>
                                    </div>
                                </td>

                                <td class="px-6 py-4">
                                    <div class="flex flex-col gap-1">
                                        <span class="text-xs bg-slate-100 text-slate-600 px-2 py-1 rounded">Weekday: ₹<?php echo $row['weekday_rate'] ?? 0; ?></span>
                                        <span class="text-xs bg-green-50 text-green-700 px-2 py-1 rounded">Weekend: ₹<?php echo $row['weekend_rate'] ?? 0; ?></span>
                                    </div>
                                </td>

                                <td class="px-6 py-4 text-right">
                                    <div class="flex items-center justify-end gap-2">
                                        <a href="edit_enquiry.php?id=<?php echo $row['id']; ?>" class="p-2 text-blue-600 hover:bg-blue-50 rounded-lg transition-colors" title="Edit">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                                            </svg>
                                        </a>
                                        
                                        <a href="javascript:void(0)" onclick="confirmDelete(<?php echo $row['id']; ?>)" class="p-2 text-red-500 hover:bg-red-50 rounded-lg transition-colors" title="Delete">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                            </svg>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="6" class="px-6 py-12 text-center text-slate-400">
                                    <div class="flex flex-col items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12 mb-4 text-slate-200" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4" />
                                        </svg>
                                        <p>No hotel records found.</p>
                                        <a href="../index.php" class="mt-4 text-blue-600 font-bold text-sm hover:underline">Add your first hotel</a>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        function confirmDelete(id) {
            if(confirm('Are you sure you want to delete this hotel? This action cannot be undone.')) {
                window.location.href = 'index.php?delete_id=' + id;
            }
        }
    </script>
</body>
</html>